/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientTickTimer {
    private static long currentTick = 0L;
    private static LinkedHashMap<Runnable, Long> runnables = new LinkedHashMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void update(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++currentTick;
            for (Map.Entry entry : runnables.entrySet().toArray(new Map.Entry[0])) {
                if (currentTick < (Long)entry.getValue()) continue;
                runnables.remove(entry.getKey());
                ((Runnable)entry.getKey()).run();
            }
        }
    }

    public static long currentTick() {
        return currentTick;
    }

    public static void schedule(int tickDelay, Runnable runnable) {
        runnables.put(runnable, currentTick + (long)tickDelay);
    }

    public static void unschedule(Runnable runnable) {
        runnables.remove(runnable);
    }

    static {
        MinecraftForge.EVENT_BUS.register(ClientTickTimer.class);
    }
}

