/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.network;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.event.LevelUpEvent;
import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.base.ExperienceHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageLevelUp
implements IMessage,
IMessageHandler<MessageLevelUp, IMessage> {
    public ResourceLocation skillName;

    public MessageLevelUp() {
    }

    public MessageLevelUp(ResourceLocation skillName) {
        this.skillName = skillName;
    }

    public void fromBytes(ByteBuf buf) {
        this.skillName = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.skillName.toString());
    }

    public IMessage onMessage(MessageLevelUp message, MessageContext ctx) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> this.handleMessage(message, ctx));
        return null;
    }

    public IMessage handleMessage(MessageLevelUp message, MessageContext context) {
        int oldLevel;
        int cost;
        EntityPlayerMP player = context.getServerHandler().field_147369_b;
        Skill skill = (Skill)ReskillableRegistries.SKILLS.getValue(message.skillName);
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        PlayerSkillInfo info = data.getSkillInfo(skill);
        if (!(info.isCapped() || player.field_71068_ca < (cost = info.getLevelUpCost()) && !player.func_184812_l_() || MinecraftForge.EVENT_BUS.post((Event)new LevelUpEvent.Pre((EntityPlayer)player, skill, (oldLevel = info.getLevel()) + 1, oldLevel)))) {
            if (!player.func_184812_l_()) {
                ExperienceHelper.drainPlayerXP((EntityPlayer)player, ExperienceHelper.getExperienceForLevel(cost));
            }
            info.levelUp();
            data.saveAndSync();
            MinecraftForge.EVENT_BUS.post((Event)new LevelUpEvent.Post((EntityPlayer)player, skill, info.getLevel(), oldLevel));
        }
        return null;
    }
}

