/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.requirement.logic;

import codersafterdark.reskillable.api.ReskillableAPI;
import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.RequirementComparision;
import codersafterdark.reskillable.api.requirement.RequirementException;
import codersafterdark.reskillable.api.requirement.RequirementRegistry;
import codersafterdark.reskillable.api.requirement.UnobtainableRequirement;
import codersafterdark.reskillable.api.requirement.logic.DoubleRequirement;
import codersafterdark.reskillable.api.requirement.logic.FalseRequirement;
import codersafterdark.reskillable.api.requirement.logic.TrueRequirement;
import codersafterdark.reskillable.api.requirement.logic.impl.ANDRequirement;
import codersafterdark.reskillable.api.requirement.logic.impl.NANDRequirement;
import codersafterdark.reskillable.api.requirement.logic.impl.NORRequirement;
import codersafterdark.reskillable.api.requirement.logic.impl.NOTRequirement;
import codersafterdark.reskillable.api.requirement.logic.impl.ORRequirement;
import codersafterdark.reskillable.api.requirement.logic.impl.XNORRequirement;
import codersafterdark.reskillable.api.requirement.logic.impl.XORRequirement;

public class LogicParser {
    public static final FalseRequirement FALSE = new FalseRequirement();
    public static final TrueRequirement TRUE = new TrueRequirement();

    public static Requirement parseNOT(String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        return LogicParser.parseNOT(ReskillableAPI.getInstance().getRequirementRegistry().getRequirement(input));
    }

    private static Requirement parseNOT(Requirement requirement) {
        if (requirement == null) {
            return null;
        }
        if (requirement instanceof FalseRequirement || requirement instanceof UnobtainableRequirement) {
            return TRUE;
        }
        if (requirement instanceof TrueRequirement) {
            return FALSE;
        }
        if (requirement instanceof NOTRequirement) {
            return ((NOTRequirement)requirement).getRequirement();
        }
        if (requirement instanceof DoubleRequirement) {
            DoubleRequirement doubleRequirement = (DoubleRequirement)requirement;
            if (requirement instanceof ANDRequirement) {
                return new NANDRequirement(doubleRequirement.getLeft(), doubleRequirement.getRight());
            }
            if (requirement instanceof NANDRequirement) {
                return new ANDRequirement(doubleRequirement.getLeft(), doubleRequirement.getRight());
            }
            if (requirement instanceof ORRequirement) {
                return new NORRequirement(doubleRequirement.getLeft(), doubleRequirement.getRight());
            }
            if (requirement instanceof NORRequirement) {
                return new ORRequirement(doubleRequirement.getLeft(), doubleRequirement.getRight());
            }
            if (requirement instanceof XORRequirement) {
                return new XNORRequirement(doubleRequirement.getLeft(), doubleRequirement.getRight());
            }
            if (requirement instanceof XNORRequirement) {
                return new XORRequirement(doubleRequirement.getLeft(), doubleRequirement.getRight());
            }
        }
        return new NOTRequirement(requirement);
    }

    public static Requirement parseAND(String input) throws RequirementException {
        RequirementPair subRequirements = LogicParser.getSubRequirements(input);
        Requirement left = subRequirements.getLeft();
        Requirement right = subRequirements.getRight();
        if (left instanceof FalseRequirement || right instanceof FalseRequirement) {
            return FALSE;
        }
        if (left instanceof UnobtainableRequirement || right instanceof UnobtainableRequirement) {
            return new UnobtainableRequirement();
        }
        if (left instanceof TrueRequirement) {
            return right;
        }
        if (right instanceof TrueRequirement) {
            return left;
        }
        RequirementComparision matches = left.matches(right);
        if (matches.equals((Object)RequirementComparision.EQUAL_TO) || matches.equals((Object)RequirementComparision.GREATER_THAN)) {
            return left;
        }
        if (matches.equals((Object)RequirementComparision.LESS_THAN)) {
            return right;
        }
        return new ANDRequirement(left, right);
    }

    public static Requirement parseNAND(String input) throws RequirementException {
        RequirementPair subRequirements = LogicParser.getSubRequirements(input);
        Requirement left = subRequirements.getLeft();
        Requirement right = subRequirements.getRight();
        if (left instanceof FalseRequirement || right instanceof FalseRequirement || left instanceof UnobtainableRequirement || right instanceof UnobtainableRequirement) {
            return TRUE;
        }
        if (left instanceof TrueRequirement) {
            return LogicParser.parseNOT(right);
        }
        if (right instanceof TrueRequirement) {
            return LogicParser.parseNOT(left);
        }
        if (left.matches(right).equals((Object)RequirementComparision.EQUAL_TO)) {
            return LogicParser.parseNOT(left);
        }
        return new NANDRequirement(left, right);
    }

    public static Requirement parseOR(String input) throws RequirementException {
        RequirementPair subRequirements = LogicParser.getSubRequirements(input);
        Requirement left = subRequirements.getLeft();
        Requirement right = subRequirements.getRight();
        if (left instanceof TrueRequirement || right instanceof TrueRequirement) {
            return TRUE;
        }
        if (left instanceof FalseRequirement) {
            return right;
        }
        if (right instanceof FalseRequirement) {
            return left;
        }
        RequirementComparision matches = left.matches(right);
        if (matches.equals((Object)RequirementComparision.EQUAL_TO) || matches.equals((Object)RequirementComparision.LESS_THAN)) {
            return left;
        }
        if (matches.equals((Object)RequirementComparision.GREATER_THAN)) {
            return right;
        }
        if (left instanceof NOTRequirement ? !(right instanceof NOTRequirement) && ((NOTRequirement)left).getRequirement().matches(right).equals((Object)RequirementComparision.EQUAL_TO) : right instanceof NOTRequirement && left.matches(((NOTRequirement)right).getRequirement()).equals((Object)RequirementComparision.EQUAL_TO)) {
            return TRUE;
        }
        return new ORRequirement(left, right);
    }

    public static Requirement parseNOR(String input) throws RequirementException {
        RequirementPair subRequirements = LogicParser.getSubRequirements(input);
        Requirement left = subRequirements.getLeft();
        Requirement right = subRequirements.getRight();
        if (left instanceof TrueRequirement && right instanceof TrueRequirement) {
            return FALSE;
        }
        if (left instanceof FalseRequirement) {
            return LogicParser.parseNOT(right);
        }
        if (right instanceof FalseRequirement) {
            return LogicParser.parseNOT(left);
        }
        if (left.matches(right).equals((Object)RequirementComparision.EQUAL_TO)) {
            return LogicParser.parseNOT(left);
        }
        return new NORRequirement(left, right);
    }

    public static Requirement parseXOR(String input) throws RequirementException {
        RequirementPair subRequirements = LogicParser.getSubRequirements(input);
        Requirement left = subRequirements.getLeft();
        Requirement right = subRequirements.getRight();
        if (left instanceof TrueRequirement) {
            return LogicParser.parseNOT(right);
        }
        if (left instanceof FalseRequirement) {
            return right;
        }
        if (right instanceof TrueRequirement) {
            return LogicParser.parseNOT(left);
        }
        if (right instanceof FalseRequirement) {
            return left;
        }
        if (left.matches(right).equals((Object)RequirementComparision.EQUAL_TO)) {
            return FALSE;
        }
        return new XORRequirement(left, right);
    }

    public static Requirement parseXNOR(String input) throws RequirementException {
        RequirementPair subRequirements = LogicParser.getSubRequirements(input);
        Requirement left = subRequirements.getLeft();
        Requirement right = subRequirements.getRight();
        if (left instanceof TrueRequirement) {
            return right;
        }
        if (left instanceof FalseRequirement) {
            return LogicParser.parseNOT(right);
        }
        if (right instanceof TrueRequirement) {
            return left;
        }
        if (right instanceof FalseRequirement) {
            return LogicParser.parseNOT(left);
        }
        if (left.matches(right).equals((Object)RequirementComparision.EQUAL_TO)) {
            return TRUE;
        }
        return new XNORRequirement(left, right);
    }

    private static RequirementPair getSubRequirements(String input) throws RequirementException {
        if (input == null || input.length() < 5 || !input.startsWith("[") || !input.endsWith("]")) {
            throw new RequirementException("Invalid format for double requirement.");
        }
        String first = "";
        int count = 1;
        int lastChar = 91;
        int secondStart = 4;
        int closeBrackets = 0;
        for (int i = 1; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (lastChar == 93) {
                if (c == ']') {
                    ++closeBrackets;
                } else {
                    if (c == '~') {
                        count = count - 1 - closeBrackets;
                    }
                    closeBrackets = 0;
                }
            } else {
                if ((lastChar == 124 || lastChar == 126) && c == '[') {
                    ++count;
                }
                closeBrackets = 0;
            }
            if (count == 0) {
                if (!first.isEmpty()) {
                    throw new RequirementException("Something went wrong, double check brackets.");
                }
                first = input.substring(1, i - 1);
                secondStart = i + 2;
            }
            lastChar = c;
        }
        if ((count = count - 1 - closeBrackets) != 0) {
            throw new RequirementException("Mismatched brackets.");
        }
        RequirementRegistry registry = ReskillableAPI.getInstance().getRequirementRegistry();
        Requirement left = registry.getRequirement(first);
        if (left == null) {
            throw new RequirementException("Invalid left-hand requirement '" + first + "'.");
        }
        String second = input.substring(secondStart, input.length() - 1);
        Requirement right = registry.getRequirement(second);
        if (right == null) {
            throw new RequirementException("Invalid right-hand requirement '" + second + "'.");
        }
        return new RequirementPair(left, right);
    }

    private static class RequirementPair {
        private Requirement left;
        private Requirement right;

        private RequirementPair(Requirement left, Requirement right) {
            this.left = left;
            this.right = right;
        }

        private Requirement getLeft() {
            return this.left;
        }

        private Requirement getRight() {
            return this.right;
        }
    }
}

