/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.misc.util;

import java.util.ArrayList;
import java.util.List;
import net.mcft.copy.backpacks.misc.util.ClientUtils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class LangUtils {
    private LangUtils() {
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> format(String langKey, Object ... args) {
        return LangUtils.formatPrepend("", langKey, args);
    }

    @SideOnly(value=Side.CLIENT)
    public static void format(List<String> list, String langKey, Object ... args) {
        LangUtils.formatPrepend(list, "", langKey, args);
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> formatPrepend(String prepend, String langKey, Object ... args) {
        ArrayList<String> list = new ArrayList<String>();
        LangUtils.formatPrepend(list, prepend, langKey, args);
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public static void formatPrepend(List<String> list, String prepend, String langKey, Object ... args) {
        String translated = I18n.func_135052_a((String)langKey, (Object[])args);
        for (String line : translated.split("\\\\n")) {
            list.add(prepend + line);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void formatTooltip(List<String> tooltip, String tooltipKey, Object ... args) {
        LangUtils.format(tooltip, "tooltip.wearablebackpacks." + tooltipKey, args);
    }

    @SideOnly(value=Side.CLIENT)
    public static void formatTooltipPrepend(List<String> tooltip, String prepend, String tooltipKey, Object ... args) {
        LangUtils.formatPrepend(tooltip, prepend, "tooltip.wearablebackpacks." + tooltipKey, args);
    }

    @SideOnly(value=Side.CLIENT)
    public static void formatTooltipKey(List<String> tooltip, String langKey, KeyBinding keyBinding) {
        if (keyBinding.func_151463_i() == 0) {
            return;
        }
        LangUtils.formatTooltip(tooltip, langKey, "\u00a76" + keyBinding.getDisplayName() + "\u00a77");
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean tooltipIsShiftKeyDown(List<String> tooltip) {
        boolean shift = GuiScreen.func_146272_n();
        if (!shift) {
            LangUtils.formatTooltip(tooltip, "moreInfo", "\u00a76SHIFT\u00a77");
        }
        return shift;
    }

    public static void chatMessage(EntityPlayer player, String langKey, Object ... args) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.wearablebackpacks." + langKey, args));
    }

    @SideOnly(value=Side.CLIENT)
    public static void displayChatMessage(String langKey, Object ... args) {
        LangUtils.chatMessage(ClientUtils.getPlayer(), langKey, args);
    }
}

