/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.util;

import c4.champions.Champions;
import c4.champions.common.affix.AffixRegistry;
import c4.champions.common.affix.core.AffixBase;
import c4.champions.common.affix.core.AffixCategory;
import c4.champions.common.affix.filter.AffixFilterManager;
import c4.champions.common.config.ConfigHandler;
import c4.champions.common.potion.PotionPlague;
import c4.champions.common.rank.Rank;
import c4.champions.common.rank.RankManager;
import c4.champions.integrations.gamestages.ChampionStages;
import c4.champions.integrations.scalinghealth.ChampionDifficulty;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.silentchaos512.scalinghealth.api.ScalingHealthAPI;
import org.apache.logging.log4j.Level;

public class ChampionHelper {
    public static Random rand = new Random();
    private static Set<Integer> dimensions = Sets.newHashSet();
    private static Set<ResourceLocation> mobs = Sets.newHashSet();
    private static Map<Integer, List<LootData>> drops = Maps.newHashMap();
    private static Map<ResourceLocation, Tuple<Integer, Integer>> champions = Maps.newHashMap();
    private static final Field IS_COMPLETE = ReflectionHelper.findField(TileEntityBeacon.class, (String)"isComplete", (String)"field_146015_k");

    public static boolean isValidChampion(Entity entity) {
        return entity instanceof EntityLiving && entity instanceof IMob && ChampionHelper.isValidEntity(entity);
    }

    public static Rank generateRank(EntityLiving entityLivingIn) {
        ResourceLocation entityKey;
        Tuple<Integer, Integer> curated;
        ImmutableSortedMap<Integer, Rank> ranks = RankManager.getRanks();
        int finalTier = 0;
        int firstTier = (Integer)ranks.firstKey();
        float chance = ((Rank)ranks.get((Object)firstTier)).getChance();
        if (Champions.isScalingHealthLoaded) {
            double modifier = ChampionDifficulty.getSpawnModifier(firstTier);
            double difficulty = ScalingHealthAPI.getAreaDifficulty((World)entityLivingIn.field_70170_p, (BlockPos)entityLivingIn.func_180425_c());
            chance = (float)((double)chance + modifier * difficulty);
        }
        if ((curated = champions.get(entityKey = EntityList.func_191301_a((Entity)entityLivingIn))) != null) {
            if ((Integer)curated.func_76341_a() > 0) {
                finalTier = (Integer)curated.func_76341_a();
                if ((Integer)curated.func_76340_b() == 0) {
                    return (Rank)ranks.get((Object)finalTier);
                }
            } else {
                finalTier = firstTier;
            }
        } else if (rand.nextFloat() < chance) {
            if (Champions.isGameStagesLoaded && !ChampionStages.isValidTier((Integer)ranks.firstKey(), entityLivingIn) || ChampionHelper.nearActiveBeacon(entityLivingIn)) {
                return RankManager.getEmptyRank();
            }
            finalTier = firstTier;
        }
        if (finalTier > 0) {
            ImmutableSortedSet check = ranks.keySet().tailSet((Object)finalTier, false);
            for (Integer tier : check) {
                chance = ((Rank)ranks.get((Object)tier)).getChance();
                if (Champions.isScalingHealthLoaded) {
                    double modifier = ChampionDifficulty.getSpawnModifier(tier);
                    double difficulty = ScalingHealthAPI.getAreaDifficulty((World)entityLivingIn.field_70170_p, (BlockPos)entityLivingIn.func_180425_c());
                    chance = (float)((double)chance + modifier * difficulty);
                }
                if (!(rand.nextFloat() < chance) || Champions.isGameStagesLoaded && !ChampionStages.isValidTier(tier, entityLivingIn)) break;
                finalTier = tier;
            }
        }
        if (finalTier == 0) {
            return RankManager.getEmptyRank();
        }
        if (curated != null && (Integer)curated.func_76340_b() > 0) {
            finalTier = Math.min(finalTier, (Integer)curated.func_76340_b());
        }
        return (Rank)ranks.get((Object)finalTier);
    }

    public static String generateRandomName() {
        String configSuffix;
        int langSize = 24;
        int randomPrefix = rand.nextInt(langSize + ConfigHandler.championNames.length);
        int randomSuffix = rand.nextInt(langSize + ConfigHandler.championNameSuffixes.length);
        String header = "champions.%s.%d";
        String prefix = randomPrefix < langSize ? new TextComponentTranslation(String.format(header, "prefix", randomPrefix), new Object[0]).func_150254_d() : ConfigHandler.championNames[randomPrefix - langSize];
        String suffix = randomSuffix < langSize ? new TextComponentTranslation(String.format(header, "suffix", randomSuffix), new Object[0]).func_150254_d() : (!(configSuffix = ConfigHandler.championNameSuffixes[randomSuffix - langSize]).isEmpty() ? (configSuffix.charAt(0) == ',' ? configSuffix : " " + configSuffix) : "");
        return prefix + suffix;
    }

    public static Set<String> generateAffixes(Rank rank, EntityLiving entityLivingIn, String ... presets) {
        int size = rank.getAffixes();
        int tier = rank.getTier();
        HashSet affixList = Sets.newHashSet();
        Map<AffixCategory, Set> categoryMap = AffixRegistry.getCategoryMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Sets.newHashSet((Iterable)((Iterable)e.getValue()))));
        HashSet curatedPresets = Sets.newHashSet((Object[])presets);
        curatedPresets.addAll(AffixFilterManager.getPresetAffixesForEntity((Entity)entityLivingIn));
        if (curatedPresets.size() > 0) {
            for (String s : curatedPresets) {
                AffixCategory cat;
                Set availableAffixes;
                AffixBase aff = AffixRegistry.getAffix(s);
                if (aff == null || (availableAffixes = categoryMap.get((Object)(cat = aff.getCategory()))) == null || !availableAffixes.contains(s)) continue;
                availableAffixes.remove(s);
                boolean added = false;
                AffixBase affix = AffixRegistry.getAffix(s);
                if (affix != null) {
                    boolean flag = true;
                    for (String s1 : affixList) {
                        if (affix.isCompatibleWith(AffixRegistry.getAffix(s1))) continue;
                        flag = false;
                        break;
                    }
                    if (flag) {
                        affixList.add(s);
                        added = true;
                    }
                }
                if (!added || !availableAffixes.isEmpty() && cat == AffixCategory.OFFENSE) continue;
                categoryMap.remove((Object)cat);
            }
        }
        while (!categoryMap.isEmpty() && affixList.size() < size) {
            AffixCategory[] categories = categoryMap.keySet().toArray(new AffixCategory[0]);
            AffixCategory randomCategory = categories[rand.nextInt(categories.length)];
            Set affixes = categoryMap.get((Object)randomCategory);
            if (affixes.isEmpty()) continue;
            int element = rand.nextInt(affixes.size());
            Iterator iter = affixes.iterator();
            for (int i = 0; i < element; ++i) {
                iter.next();
            }
            String id = (String)iter.next();
            boolean added = false;
            AffixBase affix = AffixRegistry.getAffix(id);
            if (affix != null && affix.canApply(entityLivingIn) && AffixFilterManager.isValidAffix(affix, entityLivingIn, tier)) {
                boolean flag = true;
                for (String s : affixList) {
                    if (affix.isCompatibleWith(AffixRegistry.getAffix(s))) continue;
                    flag = false;
                    break;
                }
                if (flag) {
                    affixList.add(id);
                    added = true;
                }
            }
            if (added && randomCategory != AffixCategory.OFFENSE) {
                categoryMap.remove((Object)randomCategory);
                continue;
            }
            affixes.remove(id);
            if (!affixes.isEmpty()) continue;
            categoryMap.remove((Object)randomCategory);
        }
        return affixList;
    }

    public static boolean isElite(Rank rank) {
        return rank != null && rank.getTier() > 0;
    }

    private static boolean nearActiveBeacon(EntityLiving entityLivingIn) {
        int range = ConfigHandler.beaconRange;
        if (range <= 0) {
            return false;
        }
        for (TileEntity te : entityLivingIn.field_70170_p.field_175730_i) {
            BlockPos pos = te.func_174877_v();
            if (!(Math.sqrt(entityLivingIn.func_174818_b(pos)) <= (double)range) || !(te instanceof TileEntityBeacon)) continue;
            TileEntityBeacon beacon = (TileEntityBeacon)te;
            boolean flag = false;
            try {
                flag = IS_COMPLETE.getBoolean(beacon);
            }
            catch (IllegalAccessException e) {
                Champions.logger.log(Level.ERROR, "Error reading isComplete from beacon!");
            }
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidEntity(Entity entity) {
        ResourceLocation rl = EntityList.func_191301_a((Entity)entity);
        if (rl == null) {
            return false;
        }
        if (mobs.isEmpty()) {
            return true;
        }
        if (ConfigHandler.mobPermission == ConfigHandler.PermissionMode.BLACKLIST) {
            return !mobs.contains(rl);
        }
        return mobs.contains(rl);
    }

    public static boolean isValidDimension(int dim) {
        if (dimensions.isEmpty()) {
            return true;
        }
        if (ConfigHandler.dimensionPermission == ConfigHandler.PermissionMode.BLACKLIST) {
            return !dimensions.contains(dim);
        }
        return dimensions.contains(dim);
    }

    public static void parseConfigs() {
        Potion potion = Potion.func_180142_b((String)ConfigHandler.affix.plagued.infectPotion);
        if (potion != null) {
            PotionPlague.setInfectionPotion(potion);
        }
        if (ConfigHandler.dimensionList.length > 0) {
            for (String s : ConfigHandler.dimensionList) {
                try {
                    dimensions.add(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    Champions.logger.log(Level.ERROR, "Non-integer found in dimension config! " + s);
                }
            }
        }
        if (ConfigHandler.mobList.length > 0) {
            for (String s : ConfigHandler.mobList) {
                ResourceLocation rl = new ResourceLocation(s);
                if (EntityList.func_180124_b().contains(rl)) {
                    mobs.add(rl);
                    continue;
                }
                Champions.logger.log(Level.ERROR, "Invalid entity found in mob config! " + s);
            }
        }
        if (ConfigHandler.championsList.length > 0) {
            for (String s : ConfigHandler.championsList) {
                int maxTier;
                String[] args = s.split(";");
                ResourceLocation rl = new ResourceLocation(args[0]);
                int minTier = args.length > 1 ? Integer.parseInt(args[1]) : 0;
                int n = maxTier = args.length > 2 ? Integer.parseInt(args[2]) : 0;
                if (EntityList.func_180124_b().contains(rl)) {
                    champions.put(rl, (Tuple<Integer, Integer>)new Tuple((Object)minTier, (Object)maxTier));
                    continue;
                }
                Champions.logger.log(Level.ERROR, "Invalid entity found in champions list config! " + s);
            }
        }
        if (ConfigHandler.lootDrops.length > 0) {
            for (String s : ConfigHandler.lootDrops) {
                int tier;
                String[] parsed = s.split(";");
                if (parsed.length <= 0) continue;
                int metadata = 0;
                int stackSize = 1;
                boolean enchant = false;
                int weight = 1;
                if (parsed.length < 2) {
                    Champions.logger.log(Level.ERROR, s + " needs at least a tier and an item name");
                    continue;
                }
                try {
                    tier = Integer.parseInt(parsed[0]);
                }
                catch (NumberFormatException e) {
                    Champions.logger.log(Level.ERROR, parsed[0] + " is not a valid tier");
                    continue;
                }
                Item item = Item.func_111206_d((String)parsed[1]);
                if (item == null) {
                    Champions.logger.log(Level.ERROR, "Item not found!" + parsed[1]);
                    continue;
                }
                if (parsed.length > 2) {
                    try {
                        metadata = Integer.parseInt(parsed[2]);
                    }
                    catch (NumberFormatException e) {
                        Champions.logger.log(Level.ERROR, parsed[2] + " is not a valid metadata");
                    }
                    if (parsed.length > 3) {
                        try {
                            stackSize = Integer.parseInt(parsed[3]);
                        }
                        catch (NumberFormatException e) {
                            Champions.logger.log(Level.ERROR, parsed[3] + " is not a valid stack creeperStrength");
                        }
                        if (parsed.length > 4) {
                            if (parsed[4].equalsIgnoreCase("true")) {
                                enchant = true;
                            }
                            if (parsed.length > 5) {
                                try {
                                    weight = Integer.parseInt(parsed[5]);
                                }
                                catch (NumberFormatException e) {
                                    Champions.logger.log(Level.ERROR, parsed[5] + " is not a valid weight");
                                }
                            }
                        }
                    }
                }
                ItemStack stack = new ItemStack(item, stackSize, metadata);
                drops.computeIfAbsent(tier, list -> Lists.newArrayList()).add(new LootData(stack, enchant, weight));
            }
        }
    }

    public static List<ItemStack> getLootDrops(int tier) {
        ArrayList data = Lists.newArrayList((Iterable)drops.getOrDefault(tier, Lists.newArrayList()));
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (data.isEmpty()) {
            return drops;
        }
        int amount = ConfigHandler.lootScaling ? tier : 1;
        block0: for (int i = 0; i < amount; ++i) {
            double totalWeight = 0.0;
            for (LootData loot : data) {
                totalWeight += (double)loot.weight;
            }
            double random = rand.nextDouble() * totalWeight;
            double countWeight = 0.0;
            for (LootData loot : data) {
                if (!((countWeight += (double)loot.weight) >= random)) continue;
                drops.add(loot.getLootStack());
                continue block0;
            }
        }
        return drops;
    }

    private static class LootData {
        private ItemStack stack;
        private boolean enchant;
        private int weight;

        LootData(ItemStack stack, boolean enchant, int weight) {
            this.stack = stack;
            this.enchant = enchant;
            this.weight = weight;
        }

        public ItemStack getLootStack() {
            ItemStack loot = this.stack.func_77946_l();
            if (this.enchant) {
                EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)loot, (int)30, (boolean)true);
            }
            return loot;
        }
    }
}

