/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.command;

import c4.champions.common.affix.AffixRegistry;
import c4.champions.common.affix.core.AffixBase;
import c4.champions.common.capability.CapabilityChampionship;
import c4.champions.common.capability.IChampionship;
import c4.champions.common.rank.Rank;
import c4.champions.common.rank.RankManager;
import c4.champions.common.util.ChampionHelper;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommandSpawnChampionAt
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "spawnchampionat";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "champions.commands.spawnchampionat.usage";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        int tier;
        if (args.length < 5) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        double posX = CommandSpawnChampionAt.func_175765_c((String)args[0]);
        double posY = CommandSpawnChampionAt.func_175765_c((String)args[1]);
        double posZ = CommandSpawnChampionAt.func_175765_c((String)args[2]);
        BlockPos blockPos = new BlockPos(posX, posY, posZ);
        Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(args[3]), (World)sender.func_130014_f_());
        if (!(entity instanceof EntityLiving)) {
            throw new CommandException("champions.commands.spawnchampion.entityError", new Object[]{args[3]});
        }
        EntityLiving living = (EntityLiving)entity;
        try {
            tier = Integer.parseInt(args[4]);
        }
        catch (NumberFormatException e) {
            throw new CommandException("champions.commands.spawnchampion.tierError", new Object[]{args[4]});
        }
        HashSet argAffix = Sets.newHashSet();
        for (int i = 5; i < args.length; ++i) {
            String affix = args[i];
            AffixBase affixBase = AffixRegistry.getAffix(affix);
            if (affixBase == null) {
                throw new CommandException("champions.commands.spawnchampion.affixError", new Object[]{args[i]});
            }
            argAffix.add(args[i]);
        }
        World world = sender.func_130014_f_();
        living.func_70107_b((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
        IChampionship chp = CapabilityChampionship.getChampionship(living);
        if (chp != null) {
            Rank rank = RankManager.getRankForTier(tier);
            chp.setRank(rank);
            if (rank.getTier() > 0) {
                if (argAffix.isEmpty()) {
                    Set<String> affixes = ChampionHelper.generateAffixes(rank, living, new String[0]);
                    chp.setAffixes(affixes);
                } else {
                    chp.setAffixes(argAffix);
                }
                chp.setName(ChampionHelper.generateRandomName());
                chp.getRank().applyGrowth((EntityLivingBase)living);
                for (String s : chp.getAffixes()) {
                    AffixBase affix = AffixRegistry.getAffix(s);
                    if (affix == null) continue;
                    affix.onInitialSpawn(living, chp);
                }
            }
        }
        living.func_180482_a(world.func_175649_E(blockPos), null);
        world.func_72838_d((Entity)living);
        CommandSpawnChampionAt.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"champions.commands.spawnchampion.success", (Object[])new Object[]{blockPos});
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }
}

