/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.network.capability;

import com.alcatrazescapee.alcatrazcore.network.capability.CapabilityContainerListener;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;

public class CapabilityContainerListenerManager {
    private static final Set<Function<EntityPlayerMP, CapabilityContainerListener<?>>> containerListenerFactories = new HashSet();

    public static void registerContainerListenerFactory(Function<EntityPlayerMP, CapabilityContainerListener<?>> factory) {
        containerListenerFactories.add(factory);
    }

    private static void addListeners(EntityPlayerMP player, Container container) {
        containerListenerFactories.forEach(factory -> container.func_75132_a((IContainerListener)factory.apply(player)));
    }

    @Mod.EventBusSubscriber(modid="alcatrazcore", value={Side.SERVER})
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.player instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)event.player;
                CapabilityContainerListenerManager.addListeners(player, player.field_71069_bz);
            }
        }

        @SubscribeEvent
        public static void onPlayerCloneEvent(PlayerEvent.Clone event) {
            if (event.getEntityPlayer() instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
                CapabilityContainerListenerManager.addListeners(player, player.field_71069_bz);
            }
        }

        @SubscribeEvent
        public static void onContainerOpenEvent(PlayerContainerEvent.Open event) {
            if (event.getEntityPlayer() instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
                CapabilityContainerListenerManager.addListeners(player, event.getContainer());
            }
        }
    }
}

