/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.inventory.container;

import com.alcatrazescapee.alcatrazcore.tile.ITileFields;
import com.alcatrazescapee.alcatrazcore.tile.TileInventory;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ContainerTileInventory<T extends TileInventory>
extends Container {
    protected final T tile;
    protected final InventoryPlayer playerInv;
    private final boolean shouldSendFields;
    private int[] cachedFields;

    public ContainerTileInventory(InventoryPlayer playerInv, T tile) {
        this(playerInv, tile, 0, 0);
    }

    public ContainerTileInventory(InventoryPlayer playerInv, T tile, int playerSlotOffsetX, int playerSlotOffsetY) {
        this.tile = tile;
        this.playerInv = playerInv;
        this.shouldSendFields = tile instanceof ITileFields;
        this.addContainerSlots();
        this.addPlayerInventorySlots(playerInv, playerSlotOffsetX, playerSlotOffsetY);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.shouldSendFields) {
            this.detectAndSendFieldChanges();
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack stackCopy = stack.func_77946_l();
        int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
        if (index < containerSlots) {
            if (!this.func_75135_a(stack, containerSlots, this.field_75151_b.size(), true)) {
                return ItemStack.field_190927_a;
            }
            ((TileInventory)((Object)this.tile)).setAndUpdateSlots(index);
        } else {
            for (int i = 0; i < containerSlots; ++i) {
                if (!((Slot)this.field_75151_b.get(i)).func_75214_a(stack) || !this.func_75135_a(stack, i, i + 1, false)) continue;
                ((TileInventory)((Object)this.tile)).setAndUpdateSlots(i);
            }
        }
        if (stack.func_190916_E() == 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        if (stack.func_190916_E() == stackCopy.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_190901_a(player, stack);
        return stackCopy;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (this.shouldSendFields) {
            ((ITileFields)this.tile).setField(id, data);
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return true;
    }

    protected void detectAndSendFieldChanges() {
        ITileFields tileFields = (ITileFields)this.tile;
        boolean allFieldsHaveChanged = false;
        boolean[] fieldHasChanged = new boolean[tileFields.getFieldCount()];
        if (this.cachedFields == null) {
            this.cachedFields = new int[tileFields.getFieldCount()];
            allFieldsHaveChanged = true;
        }
        for (int i = 0; i < this.cachedFields.length; ++i) {
            if (!allFieldsHaveChanged && this.cachedFields[i] == tileFields.getField(i)) continue;
            this.cachedFields[i] = tileFields.getField(i);
            fieldHasChanged[i] = true;
        }
        for (IContainerListener listener : this.field_75149_d) {
            for (int fieldID = 0; fieldID < tileFields.getFieldCount(); ++fieldID) {
                if (!fieldHasChanged[fieldID]) continue;
                listener.func_71112_a((Container)this, fieldID, this.cachedFields[fieldID]);
            }
        }
    }

    protected void detectAndSendAllChanges() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack stack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack stackOld = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)stackOld, (ItemStack)stack)) continue;
            stackOld = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
            this.field_75153_a.set(i, (Object)stackOld);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((Container)this, i, stackOld);
            }
        }
    }

    protected abstract void addContainerSlots();

    protected void addPlayerInventorySlots(InventoryPlayer playerInv, int offsetX, int offsetY) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, offsetX + 8 + j * 18, offsetY + 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInv, k, offsetX + 8 + k * 18, offsetY + 142));
        }
    }
}

