/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockNetherBrick;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import paulevs.betternether.biomes.BiomeRegister;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.config.ConfigLoader;
import paulevs.betternether.noise.Dither;
import paulevs.betternether.noise.WorleyNoiseIDDistorted3D;
import paulevs.betternether.structures.IStructureWorld;
import paulevs.betternether.structures.StructureAltar;
import paulevs.betternether.structures.StructureBuilding;
import paulevs.betternether.structures.city.CityStructureManager;
import paulevs.betternether.structures.plants.StructureBlackApple;
import paulevs.betternether.structures.plants.StructureEggPlant;
import paulevs.betternether.structures.plants.StructureEye;
import paulevs.betternether.structures.plants.StructureGrayMold;
import paulevs.betternether.structures.plants.StructureInkBush;
import paulevs.betternether.structures.plants.StructureLucis;
import paulevs.betternether.structures.plants.StructureMagmaFlower;
import paulevs.betternether.structures.plants.StructureMedBrownMushroom;
import paulevs.betternether.structures.plants.StructureMedRedMushroom;
import paulevs.betternether.structures.plants.StructureOrangeMushroom;
import paulevs.betternether.structures.plants.StructureRedMold;
import paulevs.betternether.structures.plants.StructureSmoker;
import paulevs.betternether.structures.plants.StructureStalagnate;
import paulevs.betternether.structures.plants.StructureWartCap;
import paulevs.betternether.structures.plants.StructureWartTree;

public class BNWorldGenerator {
    public static StructureEye eyeGen = new StructureEye();
    public static StructureStalagnate stalagnateGen = new StructureStalagnate();
    public static StructureLucis lucisGen = new StructureLucis();
    public static StructureSmoker smokerGen = new StructureSmoker();
    public static StructureWartTree wartTreeGen = new StructureWartTree();
    public static StructureEggPlant eggPlantGen = new StructureEggPlant();
    public static StructureInkBush inkBushGen = new StructureInkBush();
    public static StructureBlackApple blackAppleGen = new StructureBlackApple();
    public static StructureMagmaFlower magmaFlowerGen = new StructureMagmaFlower();
    public static StructureMedRedMushroom redMushroomGen = new StructureMedRedMushroom();
    public static StructureMedBrownMushroom brownMushroomGen = new StructureMedBrownMushroom();
    public static StructureOrangeMushroom orangeMushroomGen = new StructureOrangeMushroom();
    public static StructureRedMold redMoldGen = new StructureRedMold();
    public static StructureGrayMold grayMoldGen = new StructureGrayMold();
    public static StructureWartCap wartCapGen = new StructureWartCap();
    public static IStructureWorld[] globalStructuresLand;
    public static IStructureWorld[] globalStructuresLava;
    public static IStructureWorld[] globalStructuresCave;
    public static boolean hasCleaningPass;
    public static boolean hasEyeGen;
    public static boolean hasStalagnateGen;
    public static boolean hasLucisGen;
    public static boolean hasSmokerGen;
    public static boolean hasWartTreeGen;
    public static boolean hasEggPlantGen;
    public static boolean hasInkBushGen;
    public static boolean hasBlackAppleGen;
    public static boolean hasMagmaFlowerGen;
    public static boolean hasRedMushroomGen;
    public static boolean hasBrownMushroomGen;
    public static boolean hasOrangeMushroomGen;
    public static boolean hasRedMoldGen;
    public static boolean hasGrayMoldGen;
    public static boolean hasWartsGen;
    private static WorleyNoiseIDDistorted3D noise3d;
    private static WorleyNoiseIDDistorted3D subbiomesNoise;
    private static Dither dither;
    private static double biomeSizeXZ;
    private static double biomeSizeY;
    private static double subBiomeSize;
    private static float plantDensity;
    private static float structueDensity;
    private static float oreDensity;
    public static boolean enablePlayerDamage;
    public static boolean enableMobDamage;
    private static Random coordinateRandom;
    private static IBlockState state_air;
    private static CityStructureManager cityManager;
    private static BlockPos pos;
    private static BlockPos.MutableBlockPos popPos;
    private static final NetherBiome[][][] BIO_ARRAY;

    public static void init(World world) {
        long seed = world.func_72905_C();
        noise3d = new WorleyNoiseIDDistorted3D(seed, BiomeRegister.biomeCount);
        subbiomesNoise = new WorleyNoiseIDDistorted3D(seed ^ 0xFFFFFFFFFFFFFFFFL, 256);
        dither = new Dither(seed);
        coordinateRandom = new Random();
        if (ConfigLoader.hasCities()) {
            cityManager = new CityStructureManager(seed);
            cityManager.load(world);
            cityManager.setDistance(ConfigLoader.getCityDistance());
        }
    }

    public static void save(World world) {
        if (cityManager != null) {
            cityManager.save(world);
        }
    }

    private static void makeBiomeArray(int sx, int sz) {
        for (int x = 0; x < 8; ++x) {
            int wx = sx | x << 1;
            for (int y = 0; y < 64; ++y) {
                int wy = y << 1;
                for (int z = 0; z < 8; ++z) {
                    int wz = sz | z << 1;
                    int id = BNWorldGenerator.getBiome(wx, wy, wz);
                    BNWorldGenerator.BIO_ARRAY[x][y][z] = BiomeRegister.getBiomeID(id);
                    BNWorldGenerator.BIO_ARRAY[x][y][z] = BNWorldGenerator.isEdge(id, wx, wy, wz, BIO_ARRAY[x][y][z].getEdgeSize()) ? BIO_ARRAY[x][y][z].getEdge() : BIO_ARRAY[x][y][z].getSubBiome(wx, wy, wz);
                }
            }
        }
    }

    private static NetherBiome getBiomeLocal(int x, int y, int z, Random random) {
        if ((x = x + random.nextInt(2) >> 1) > 7) {
            x = 7;
        }
        if ((y = y + random.nextInt(2) >> 1) > 63) {
            y = 63;
        }
        if ((z = z + random.nextInt(2) >> 1) > 7) {
            z = 7;
        }
        return BIO_ARRAY[x][y][z];
    }

    public static void generate(World world, int cx, int cz, Random random) {
        if (!world.field_72995_K) {
            int sx = cx << 4 | 8;
            int sz = cz << 4 | 8;
            if (coordinateRandom.nextFloat() < structueDensity) {
                pos = new BlockPos(sx + coordinateRandom.nextInt(8), 32 + coordinateRandom.nextInt(88), sz + coordinateRandom.nextInt(8));
                while (world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a && pos.func_177956_o() > 32) {
                    pos = pos.func_177977_b();
                }
                if ((pos = BNWorldGenerator.downRay(world, pos)) != null) {
                    boolean terrain = true;
                    for (int y = 1; y < 8; ++y) {
                        if (world.func_180495_p(pos.func_177981_b(y)).func_177230_c() == Blocks.field_150350_a) continue;
                        terrain = false;
                        break;
                    }
                    if (terrain) {
                        if (globalStructuresLava.length > 0 && world.func_180495_p(pos).func_185904_a() == Material.field_151587_i) {
                            globalStructuresLava[coordinateRandom.nextInt(globalStructuresLava.length)].generateLava(world, pos.func_177984_a(), coordinateRandom);
                        } else if (globalStructuresLand.length > 0) {
                            globalStructuresLand[coordinateRandom.nextInt(globalStructuresLand.length)].generateSurface(world, pos.func_177984_a(), coordinateRandom);
                        }
                    } else if (globalStructuresCave.length > 0) {
                        globalStructuresCave[coordinateRandom.nextInt(globalStructuresCave.length)].generateSubterrain(world, pos, coordinateRandom);
                    }
                }
            }
            BNWorldGenerator.makeBiomeArray(sx, sz);
            for (int x = 0; x < 16; ++x) {
                int wx = sx + x;
                for (int z = 0; z < 16; ++z) {
                    int wz = sz + z;
                    for (int y = 5; y < 126; ++y) {
                        popPos.func_181079_c(wx, y, wz);
                        if (world.func_180495_p((BlockPos)popPos).func_185913_b()) {
                            NetherBiome biome = BNWorldGenerator.getBiomeLocal(x, y, z, random);
                            if (world.func_180495_p(popPos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                                biome.genSurfColumn(world, (BlockPos)popPos, random);
                                if (random.nextFloat() <= plantDensity) {
                                    biome.genFloorObjects(world, (BlockPos)popPos, random);
                                }
                            } else if (world.func_180495_p(popPos.func_177977_b()).func_177230_c() == Blocks.field_150350_a) {
                                if (random.nextFloat() <= plantDensity) {
                                    biome.genCeilObjects(world, (BlockPos)popPos, random);
                                }
                            } else if ((x + y + z & 1) == 0) {
                                boolean bWest;
                                boolean bNorth = world.func_180495_p(popPos.func_177978_c()).func_177230_c() == Blocks.field_150350_a;
                                boolean bSouth = world.func_180495_p(popPos.func_177968_d()).func_177230_c() == Blocks.field_150350_a;
                                boolean bEast = world.func_180495_p(popPos.func_177974_f()).func_177230_c() == Blocks.field_150350_a;
                                boolean bl = bWest = world.func_180495_p(popPos.func_177976_e()).func_177230_c() == Blocks.field_150350_a;
                                if (bNorth || bSouth || bEast || bWest) {
                                    boolean bUp;
                                    BlockPos objPos = null;
                                    objPos = bNorth ? popPos.func_177978_c() : (bSouth ? popPos.func_177968_d() : (bEast ? popPos.func_177974_f() : popPos.func_177976_e()));
                                    boolean bDown = world.func_180495_p(objPos.func_177984_a()).func_177230_c() == Blocks.field_150350_a;
                                    boolean bl2 = bUp = world.func_180495_p(objPos.func_177977_b()).func_177230_c() == Blocks.field_150350_a;
                                    if (bDown && bUp) {
                                        if (random.nextFloat() <= plantDensity) {
                                            biome.genWallObjects(world, (BlockPos)popPos, objPos, random);
                                        }
                                        if (y < 37 && world.func_180495_p((BlockPos)popPos).func_177230_c() instanceof BlockNetherBrick && random.nextInt(512) == 0) {
                                            wartCapGen.generate(world, (BlockPos)popPos, random);
                                        }
                                    }
                                }
                            }
                        }
                        if (BlocksRegister.BLOCK_CINCINNASITE_ORE == Blocks.field_150350_a || random.nextInt(1024) != 0) continue;
                        BNWorldGenerator.spawnOre(BlocksRegister.BLOCK_CINCINNASITE_ORE.func_176223_P(), world, (BlockPos)popPos, random);
                    }
                }
            }
        }
    }

    private static boolean isEdge(int centerID, int x, int y, int z, int distance) {
        return distance > 0 && (centerID != BNWorldGenerator.getBiome(x + distance, y, z) || centerID != BNWorldGenerator.getBiome(x - distance, y, z) || centerID != BNWorldGenerator.getBiome(x, y + distance, z) || centerID != BNWorldGenerator.getBiome(x, y - distance, z) || centerID != BNWorldGenerator.getBiome(x, y, z + distance) || centerID != BNWorldGenerator.getBiome(x, y, z - distance));
    }

    private static int getBiome(int x, int y, int z) {
        double px = (double)dither.ditherX(x, y, z) * biomeSizeXZ;
        double py = (double)dither.ditherY(x, y, z) * biomeSizeY;
        double pz = (double)dither.ditherZ(x, y, z) * biomeSizeXZ;
        return noise3d.GetValue(px, py, pz);
    }

    public static void smoothChunk(World world, int cx, int cz) {
        if (hasCleaningPass) {
            int wx = cx << 4 | 8;
            int wz = cz << 4 | 8;
            ArrayList<BlockPos> pos = new ArrayList<BlockPos>();
            for (int y = 32; y < 110; ++y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        popPos.func_181079_c(x + wx, y, z + wz);
                        if (!BNWorldGenerator.canReplace(world, (BlockPos)popPos)) continue;
                        BlockPos up = popPos.func_177984_a();
                        BlockPos down = popPos.func_177977_b();
                        BlockPos north = popPos.func_177978_c();
                        BlockPos south = popPos.func_177968_d();
                        BlockPos east = popPos.func_177974_f();
                        BlockPos west = popPos.func_177976_e();
                        if (BNWorldGenerator.isAir(world, north) && BNWorldGenerator.isAir(world, south)) {
                            pos.add(new BlockPos((Vec3i)popPos));
                            continue;
                        }
                        if (BNWorldGenerator.isAir(world, east) && BNWorldGenerator.isAir(world, west)) {
                            pos.add(new BlockPos((Vec3i)popPos));
                            continue;
                        }
                        if (BNWorldGenerator.isAir(world, up) && BNWorldGenerator.isAir(world, down)) {
                            pos.add(new BlockPos((Vec3i)popPos));
                            continue;
                        }
                        if (BNWorldGenerator.isAir(world, popPos.func_177978_c().func_177974_f().func_177977_b()) && BNWorldGenerator.isAir(world, popPos.func_177968_d().func_177976_e().func_177984_a())) {
                            pos.add(new BlockPos((Vec3i)popPos));
                            continue;
                        }
                        if (BNWorldGenerator.isAir(world, popPos.func_177968_d().func_177974_f().func_177977_b()) && BNWorldGenerator.isAir(world, popPos.func_177978_c().func_177976_e().func_177984_a())) {
                            pos.add(new BlockPos((Vec3i)popPos));
                            continue;
                        }
                        if (BNWorldGenerator.isAir(world, popPos.func_177978_c().func_177976_e().func_177977_b()) && BNWorldGenerator.isAir(world, popPos.func_177968_d().func_177974_f().func_177984_a())) {
                            pos.add(new BlockPos((Vec3i)popPos));
                            continue;
                        }
                        if (!BNWorldGenerator.isAir(world, popPos.func_177968_d().func_177976_e().func_177977_b()) || !BNWorldGenerator.isAir(world, popPos.func_177978_c().func_177974_f().func_177984_a())) continue;
                        pos.add(new BlockPos((Vec3i)popPos));
                    }
                }
            }
            for (BlockPos p : pos) {
                world.func_175656_a(p, state_air);
            }
        }
        if (cityManager != null) {
            cityManager.generate(world, cx, cz);
        }
    }

    private static boolean isAir(World chunk, BlockPos pos) {
        return chunk.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
    }

    private static boolean canReplace(World chunk, BlockPos pos) {
        return !BNWorldGenerator.isAir(chunk, pos) && (chunk.func_180495_p(pos).func_177230_c() instanceof BlockNetherrack || chunk.func_180495_p(pos).func_177230_c() instanceof BlockSoulSand || chunk.func_180495_p(pos).func_177230_c() instanceof BlockGravel);
    }

    private static void spawnOre(IBlockState state, World world, BlockPos pos, Random random) {
        for (int i = 0; i < 6 + random.nextInt(11); ++i) {
            BlockPos local = pos.func_177982_a(random.nextInt(3), random.nextInt(3), random.nextInt(3));
            if (world.func_180495_p(local).func_177230_c() != Blocks.field_150424_aL) continue;
            world.func_175656_a(local, state);
        }
    }

    public static void updateGenSettings() {
        biomeSizeXZ = 1.0 / (double)ConfigLoader.getBiomeSizeXZ();
        biomeSizeY = 1.0 / (double)ConfigLoader.getBiomeSizeY();
        subBiomeSize = biomeSizeXZ * 3.0;
        hasCleaningPass = ConfigLoader.hasCleaningPass();
        hasEyeGen = BlocksRegister.BLOCK_EYE_VINE != Blocks.field_150350_a && BlocksRegister.BLOCK_EYEBALL != Blocks.field_150350_a && BlocksRegister.BLOCK_EYEBALL_SMALL != Blocks.field_150350_a;
        hasStalagnateGen = BlocksRegister.BLOCK_STALAGNATE_BOTTOM != Blocks.field_150350_a && BlocksRegister.BLOCK_STALAGNATE_MIDDLE != Blocks.field_150350_a && BlocksRegister.BLOCK_STALAGNATE_TOP != Blocks.field_150350_a;
        hasLucisGen = BlocksRegister.BLOCK_LUCIS_MUSHROOM != Blocks.field_150350_a;
        hasSmokerGen = BlocksRegister.BLOCK_SMOKER != Blocks.field_150350_a;
        hasWartTreeGen = BlocksRegister.BLOCK_WART_SEED != Blocks.field_150350_a;
        hasEggPlantGen = BlocksRegister.BLOCK_EGG_PLANT != Blocks.field_150350_a;
        hasInkBushGen = BlocksRegister.BLOCK_INK_BUSH != Blocks.field_150350_a;
        hasBlackAppleGen = BlocksRegister.BLOCK_BLACK_APPLE != Blocks.field_150350_a;
        hasMagmaFlowerGen = BlocksRegister.BLOCK_MAGMA_FLOWER != Blocks.field_150350_a;
        hasRedMushroomGen = BlocksRegister.BLOCK_RED_LARGE_MUSHROOM != Blocks.field_150350_a;
        hasBrownMushroomGen = BlocksRegister.BLOCK_BROWN_LARGE_MUSHROOM != Blocks.field_150350_a;
        hasOrangeMushroomGen = BlocksRegister.BLOCK_ORANGE_MUSHROOM != Blocks.field_150350_a;
        hasRedMoldGen = BlocksRegister.BLOCK_RED_MOLD != Blocks.field_150350_a;
        hasGrayMoldGen = BlocksRegister.BLOCK_GRAY_MOLD != Blocks.field_150350_a;
        hasWartsGen = ConfigLoader.hasNetherWart();
        globalStructuresLand = new IStructureWorld[]{new StructureAltar(), new StructureBuilding("altar_01", -1), new StructureBuilding("altar_02", -4), new StructureBuilding("altar_03", -3), new StructureBuilding("altar_04", -3), new StructureBuilding("altar_05", -2), new StructureBuilding("altar_06", -2), new StructureBuilding("portal_01", -4), new StructureBuilding("portal_02", -3), new StructureBuilding("garden_01", -3), new StructureBuilding("garden_02", -2), new StructureBuilding("pillar_01", -1), new StructureBuilding("respawn_point_01", -3), new StructureBuilding("respawn_point_02", -2)};
        globalStructuresLava = new IStructureWorld[0];
        globalStructuresCave = new IStructureWorld[]{new StructureBuilding("room_01", -5)};
    }

    private static BlockPos downRay(World world, BlockPos start) {
        boolean dist = false;
        for (int j = start.func_177956_o(); j > 31; --j) {
            BlockPos p = new BlockPos(start.func_177958_n(), j, start.func_177952_p());
            Block b = world.func_180495_p(p).func_177230_c();
            if (b == Blocks.field_150350_a || !(b instanceof BlockNetherrack) && !(b instanceof BlockSoulSand) && world.func_180495_p(p).func_185904_a() != Material.field_151587_i) continue;
            return new BlockPos(start.func_177958_n(), j, start.func_177952_p());
        }
        return null;
    }

    public static void setPlantDensity(float density) {
        plantDensity = density;
    }

    public static void setStructureDensity(float density) {
        structueDensity = density;
    }

    public static int getSubBiome(int x, int y, int z, int count) {
        double px = (double)dither.ditherX(x, y, z) * subBiomeSize;
        double py = (double)dither.ditherY(x, y, z) * subBiomeSize;
        double pz = (double)dither.ditherZ(x, y, z) * subBiomeSize;
        return subbiomesNoise.GetValue(px, py, pz) % count;
    }

    public static NetherBiome getBiome(BlockPos pos) {
        int id = BNWorldGenerator.getBiome(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        NetherBiome biome = BiomeRegister.getBiomeID(id);
        biome = BNWorldGenerator.isEdge(id, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), biome.getEdgeSize()) ? biome.getEdge() : biome.getSubBiome(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return biome;
    }

    public static BlockPos getNearestCity(World world, int cx, int cz) {
        return cityManager.getNearestStructure(world, cx, cz);
    }

    public static void setOreDensity(float density) {
        oreDensity = density;
    }

    static {
        hasCleaningPass = true;
        hasEyeGen = true;
        hasStalagnateGen = true;
        hasLucisGen = true;
        hasSmokerGen = true;
        hasWartTreeGen = true;
        hasEggPlantGen = true;
        hasInkBushGen = true;
        hasBlackAppleGen = true;
        hasMagmaFlowerGen = true;
        hasRedMushroomGen = true;
        hasBrownMushroomGen = true;
        hasOrangeMushroomGen = true;
        hasRedMoldGen = true;
        hasGrayMoldGen = true;
        hasWartsGen = true;
        plantDensity = 1.0f;
        structueDensity = 0.015625f;
        oreDensity = 9.765625E-4f;
        state_air = Blocks.field_150350_a.func_176223_P();
        popPos = new BlockPos.MutableBlockPos();
        BIO_ARRAY = new NetherBiome[8][64][8];
    }
}

