/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.tinkersconstruct.materiallocks;

import codersafterdark.compatskills.CompatSkills;
import codersafterdark.compatskills.common.compats.tinkersconstruct.TinkersCompatHandler;
import codersafterdark.compatskills.common.compats.tinkersconstruct.materiallocks.MaterialLockKey;
import codersafterdark.compatskills.utils.CheckMethods;
import codersafterdark.compatskills.utils.Utils;
import codersafterdark.reskillable.api.data.LockKey;
import codersafterdark.reskillable.api.data.RequirementHolder;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import slimeknights.tconstruct.library.TinkerRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="tconstruct")
@ZenClass(value="mods.compatskills.MaterialLock")
@ZenRegister
public class MaterialLockTweaker {
    @ZenMethod
    public static void addMaterialLock(String id, String ... requirements) {
        if (TinkersCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new AddMaterialLock(id, requirements));
        }
    }

    private static class AddMaterialLock
    implements IAction {
        private final String id;
        private final String[] requirements;

        private AddMaterialLock(String id, String ... requirements) {
            this.id = id;
            this.requirements = requirements;
        }

        public void apply() {
            if (CheckMethods.checkMaterial(this.id)) {
                TinkersCompatHandler.addTinkersLock((LockKey)new MaterialLockKey(TinkerRegistry.getMaterial((String)this.id)), RequirementHolder.fromStringList((String[])this.requirements));
            }
        }

        public String describe() {
            return "Added Material Lock for Material: " + this.id + " With Requirements: " + Utils.formatRequirements(this.requirements);
        }
    }
}

