/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.tinkersconstruct.commands;

import codersafterdark.compatskills.common.compats.tinkersconstruct.materiallocks.MaterialLockKey;
import codersafterdark.reskillable.api.data.LockKey;
import codersafterdark.reskillable.base.LevelLockHandler;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;

public class MaterialDumpCommand
extends CraftTweakerCommand {
    public MaterialDumpCommand() {
        super("tinkermaterials");
    }

    protected void init() {
        this.setDescription(new ITextComponent[]{SpecialMessagesChat.getClickableCommandText((String)(TextFormatting.DARK_GREEN + "/ct tinkersmaterials"), (String)"/ct tinkersmaterials", (boolean)true), SpecialMessagesChat.getNormalMessage((String)(TextFormatting.DARK_AQUA + "Outputs a list of all materials ids/names/descriptions in the game to the crafttweaker.log"))});
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        boolean filterLocked = args.length == 1 && args[0].equalsIgnoreCase("skipLocked");
        CraftTweakerAPI.logCommand((String)"######### Tinker's Construct Material Dump #########");
        Collection materials = TinkerRegistry.getAllMaterials();
        int size = 0;
        for (Material material : materials) {
            if (filterLocked && !LevelLockHandler.getLockByKey((LockKey)new MaterialLockKey(material)).equals(LevelLockHandler.EMPTY_LOCK)) continue;
            CraftTweakerAPI.logCommand((String)("##### " + material.getLocalizedName() + " #####"));
            CraftTweakerAPI.logCommand((String)("# Identifier: " + material.getIdentifier()));
            CraftTweakerAPI.logCommand((String)("# Localized: " + material.getLocalizedName()));
            for (ITrait trait : material.getDefaultTraits()) {
                CraftTweakerAPI.logCommand((String)"# Traits: ");
                CraftTweakerAPI.logCommand((String)("## " + trait.getLocalizedName()));
            }
            CraftTweakerAPI.logCommand((String)"#####");
            ++size;
        }
        CraftTweakerAPI.logCommand((String)"#########");
        sender.func_145747_a(SpecialMessagesChat.getNormalMessage((String)"List of Tinker's Materials Generated;"));
        sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog((String)("List Size: " + size + " Entries;"), (ICommandSender)sender));
    }

    public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.singletonList("skipLocked");
    }
}

