/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.minecraft.tileentity;

import codersafterdark.compatskills.common.compats.minecraft.tileentity.TileEntityLockKey;
import codersafterdark.compatskills.utils.Utils;
import codersafterdark.reskillable.api.data.LockKey;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.base.LevelLockHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TileEntityEventHandler {
    @SubscribeEvent
    public void onTileEntityInteract(PlayerInteractEvent.RightClickBlock event) {
        this.checkEvent((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public void onTileEntityInteract(PlayerInteractEvent.LeftClickBlock event) {
        this.checkEvent((PlayerInteractEvent)event);
    }

    private void checkEvent(PlayerInteractEvent event) {
        ResourceLocation location;
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (Utils.skipPlayer(player)) {
            return;
        }
        TileEntity entity = event.getWorld().func_175625_s(event.getPos());
        if (entity != null && (location = TileEntity.func_190559_a(entity.getClass())) != null) {
            PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
            RequirementHolder requirementHolder = LevelLockHandler.getLockByKey((LockKey)new TileEntityLockKey(location.toString()));
            if (!requirementHolder.equals(LevelLockHandler.EMPTY_LOCK) && !data.matchStats(requirementHolder)) {
                event.setCanceled(true);
                if (player.func_130014_f_().field_72995_K) {
                    TextComponentTranslation error = new TextComponentTranslation("compatskills.error.tile_entity.interact", new Object[0]);
                    player.func_146105_b(Utils.getError(requirementHolder, data, error), false);
                }
            }
        }
    }
}

