/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.minecraft.item.harvestlevel;

import codersafterdark.reskillable.api.data.FuzzyLockKey;
import codersafterdark.reskillable.api.data.LockKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ToolHarvestLock
implements FuzzyLockKey {
    private final Map<String, Integer> typeLevels = new HashMap<String, Integer>();
    private final String toolType;
    private final int harvestLevel;

    public ToolHarvestLock(String toolType, int harvestLevel) {
        this.harvestLevel = harvestLevel;
        this.toolType = toolType;
        if (this.toolType != null) {
            this.typeLevels.put(this.toolType, this.harvestLevel);
        }
    }

    public ToolHarvestLock(ItemStack stack) {
        if (stack.func_190926_b()) {
            this.harvestLevel = 0;
            this.toolType = null;
            return;
        }
        int highestLevel = 0;
        Item item = stack.func_77973_b();
        for (String toolClass : item.getToolClasses(stack)) {
            int level = item.getHarvestLevel(stack, toolClass, null, null);
            if (level < 0) continue;
            this.typeLevels.put(toolClass, level);
            if (level <= highestLevel) continue;
            highestLevel = level;
        }
        this.harvestLevel = highestLevel;
        this.toolType = null;
    }

    public boolean fuzzyEquals(FuzzyLockKey o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ToolHarvestLock) {
            ToolHarvestLock toolLock = (ToolHarvestLock)o;
            if (this.harvestLevel >= toolLock.harvestLevel) {
                if (toolLock.toolType == null) {
                    return this.toolType == null;
                }
                return toolLock.typeLevels.keySet().stream().noneMatch(s -> !this.typeLevels.containsKey(s) || this.typeLevels.get(s) < toolLock.typeLevels.get(s));
            }
        }
        return false;
    }

    public boolean isNotFuzzy() {
        return false;
    }

    public LockKey getNotFuzzy() {
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ToolHarvestLock) {
            ToolHarvestLock toolLock = (ToolHarvestLock)o;
            if (this.toolType == null) {
                return toolLock.toolType == null && this.harvestLevel == toolLock.harvestLevel;
            }
            return this.harvestLevel == toolLock.harvestLevel && this.toolType.equals(toolLock.toolType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.toolType, this.harvestLevel);
    }
}

