/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.minecraft.item;

import codersafterdark.reskillable.api.data.FuzzyLockKey;
import codersafterdark.reskillable.api.data.GenericNBTLockKey;
import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.RequirementComparision;
import codersafterdark.reskillable.api.requirement.RequirementException;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictRequirement
extends Requirement {
    private final NBTTagCompound tag;
    private final int oreEntry;

    public OreDictRequirement(String oreDictEntry, NBTTagCompound tag) {
        this.oreEntry = OreDictionary.getOreID((String)oreDictEntry);
        this.tag = tag;
        String name = oreDictEntry;
        if (tag != null) {
            name = name + " With NBT Tag: " + tag;
        }
        this.tooltip = TextFormatting.GRAY + " - " + new TextComponentTranslation("compatskills.requirements.format.ore_dict", new Object[]{"%s", name}).func_150261_e();
    }

    public static OreDictRequirement fromString(String input) throws RequirementException {
        if (input.isEmpty()) {
            throw new RequirementException("No Ore dictionary entry given.");
        }
        String[] inputInfo = input.split("\\|");
        String ore = inputInfo[0];
        if (!OreDictionary.doesOreNameExist((String)ore)) {
            throw new RequirementException("Ore dictionary entry '" + ore + "' not found.");
        }
        NBTTagCompound nbt = null;
        if (inputInfo.length > 1) {
            String nbtString = input.substring(ore.length() + 1).trim();
            try {
                nbt = JsonToNBT.func_180713_a((String)nbtString);
            }
            catch (NBTException e) {
                throw new RequirementException("Invalid NBT JSON '" + nbtString + "'.");
            }
        }
        return new OreDictRequirement(ore, nbt);
    }

    public boolean achievedByPlayer(EntityPlayer player) {
        return this.hasOreDict(player.func_184614_ca()) || this.hasOreDict(player.func_184592_cb());
    }

    private boolean hasOreDict(ItemStack stack) {
        if (stack.func_190926_b() || Arrays.stream(OreDictionary.getOreIDs((ItemStack)stack)).noneMatch(oreID -> oreID == this.oreEntry)) {
            return false;
        }
        return new GenericNBTLockKey(stack.func_77978_p()).fuzzyEquals((FuzzyLockKey)new GenericNBTLockKey(this.tag));
    }

    public RequirementComparision matches(Requirement o) {
        if (o instanceof OreDictRequirement) {
            OreDictRequirement other = (OreDictRequirement)o;
            if (this.oreEntry == other.oreEntry) {
                GenericNBTLockKey key = new GenericNBTLockKey(this.tag);
                GenericNBTLockKey otherKey = new GenericNBTLockKey(other.tag);
                if (key.fuzzyEquals((FuzzyLockKey)otherKey)) {
                    return RequirementComparision.GREATER_THAN;
                }
                if (otherKey.fuzzyEquals((FuzzyLockKey)key)) {
                    return RequirementComparision.LESS_THAN;
                }
            }
        }
        return RequirementComparision.NOT_EQUAL;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OreDictRequirement) {
            OreDictRequirement oreReq = (OreDictRequirement)((Object)o);
            if (this.tag == null) {
                return this.oreEntry == oreReq.oreEntry && oreReq.tag == null;
            }
            return this.oreEntry == oreReq.oreEntry && this.tag.equals((Object)oreReq.tag);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.oreEntry, this.tag);
    }
}

