/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.generation;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.client.rendering.MazeVisualizationContext;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceStructureListGeneration;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.world.gen.feature.structure.Placer;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ListGeneration
extends GenerationType
implements WeightedSelector.Item {
    public String listID;
    public Double weight;
    public BlockPos shift;
    public EnumFacing front;

    public ListGeneration() {
        this(null, "", null, BlockPos.field_177992_a, EnumFacing.NORTH);
    }

    public ListGeneration(@Nullable String id, String listID, Double weight, BlockPos shift, EnumFacing front) {
        super(id != null ? id : ListGeneration.randomID(ListGeneration.class));
        this.listID = listID;
        this.weight = weight;
        this.shift = shift;
        this.front = front;
    }

    public static Stream<Pair<Structure<?>, ListGeneration>> structures(StructureRegistry registry, String listID, @Nullable EnumFacing front) {
        Predicate<Pair> predicate = input -> listID.equals(((ListGeneration)input.getRight()).listID) && (front == null || ((Structure)input.getLeft()).isRotatable() || ((ListGeneration)input.getRight()).front == front);
        return registry.getGenerationTypes(ListGeneration.class).stream().filter(predicate);
    }

    @Override
    @Nonnull
    public String id() {
        return this.id;
    }

    @Override
    public void setID(@Nonnull String id) {
        this.id = id;
    }

    public BlockPos getShift() {
        return this.shift;
    }

    public void setShift(BlockPos shift) {
        this.shift = shift;
    }

    @Override
    public String displayString() {
        return IvTranslations.format((String)"reccomplex.generationInfo.structureList.title", (Object[])new Object[]{this.listID});
    }

    @Override
    @Nullable
    public Placer placer() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(MazeVisualizationContext mazeVisualizationContext, TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceStructureListGeneration(navigator, delegate, this);
    }

    public double getWeight() {
        return this.weight != null ? this.weight : 1.0;
    }

    public static class Serializer
    implements JsonSerializer<ListGeneration>,
    JsonDeserializer<ListGeneration> {
        public ListGeneration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "vanillaStructureSpawnInfo");
            String id = GenerationType.readID(jsonObject);
            String listID = JsonUtils.getString(jsonObject, "listID", "");
            Double weight = jsonObject.has("weight") ? Double.valueOf(JsonUtils.getDouble(jsonObject, "weight")) : null;
            int positionX = JsonUtils.getInt(jsonObject, "positionX", 0);
            int positionY = JsonUtils.getInt(jsonObject, "positionY", 0);
            int positionZ = JsonUtils.getInt(jsonObject, "positionZ", 0);
            EnumFacing front = Directions.deserialize((String)JsonUtils.getString(jsonObject, "front", "NORTH"));
            return new ListGeneration(id, listID, weight, new BlockPos(positionX, positionY, positionZ), front);
        }

        public JsonElement serialize(ListGeneration src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", src.id);
            jsonObject.addProperty("listID", src.listID);
            if (src.weight != null) {
                jsonObject.addProperty("weight", (Number)src.weight);
            }
            jsonObject.addProperty("positionX", (Number)src.shift.func_177958_n());
            jsonObject.addProperty("positionY", (Number)src.shift.func_177956_o());
            jsonObject.addProperty("positionZ", (Number)src.shift.func_177952_p());
            jsonObject.addProperty("front", Directions.serialize((EnumFacing)src.front));
            return jsonObject;
        }
    }
}

