/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import ivorius.reccomplex.world.gen.feature.decoration.RCBiomeDecorator;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.VanillaDecorationGeneration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class MapGenStructureHook
extends MapGenStructure {
    public MapGenStructure base;
    public RCBiomeDecorator.DecorationType decorationType;

    public MapGenStructureHook(MapGenStructure base, RCBiomeDecorator.DecorationType decorationType) {
        this.base = base;
        this.decorationType = decorationType;
    }

    public MapGenStructureHook(MapGenStructure base) {
        this.base = base;
    }

    public static Long2ObjectMap<StructureStart> getStructureMap(MapGenStructure gen) {
        return (Long2ObjectMap)ReflectionHelper.getPrivateValue(MapGenStructure.class, (Object)gen, (String)"structureMap", (String)"field_75053_d");
    }

    public static void initializeStructureData(MapGenStructure gen, World world) {
        Method method = ReflectionHelper.findMethod(MapGenStructure.class, (String)"initializeStructureData", (String)"func_143027_a", (Class[])new Class[]{World.class});
        try {
            method.invoke((Object)gen, world);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void setStructureStart(MapGenStructure gen, int x, int z, StructureStart start) {
        Method method = ReflectionHelper.findMethod(MapGenStructure.class, (String)"setStructureStart", (String)"func_143026_a", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, StructureStart.class});
        try {
            method.invoke((Object)gen, x, z, start);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static StructureStart getStructureStart(MapGenStructure gen, ChunkPos chunkPos) {
        return (StructureStart)MapGenStructureHook.getStructureMap(gen).get(ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b));
    }

    public String func_143025_a() {
        String name = this.base != null ? this.base.func_143025_a() : null;
        return name != null ? name : "";
    }

    public boolean func_175794_a(World worldIn, Random randomIn, ChunkPos chunkCoord) {
        return this.base.func_175794_a(worldIn, randomIn, chunkCoord);
    }

    public boolean func_175795_b(BlockPos pos) {
        return this.base.func_175795_b(pos);
    }

    public boolean func_175796_a(World worldIn, BlockPos pos) {
        return this.base.func_175796_a(worldIn, pos);
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        return this.base.func_180706_b(worldIn, pos, findUnexplored);
    }

    public boolean func_75047_a(int chunkX, int chunkZ) {
        Method method = ReflectionHelper.findMethod(MapGenStructure.class, (String)"canSpawnStructureAtCoords", (String)"func_75047_a", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
        try {
            return (Boolean)method.invoke((Object)this.base, chunkX, chunkZ);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return null;
    }

    public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
        this.field_75039_c = worldIn;
        WorldServer server = (WorldServer)worldIn;
        this.field_75038_b.setSeed(worldIn.func_72905_C());
        long j = this.field_75038_b.nextLong();
        long k = this.field_75038_b.nextLong();
        MapGenStructureHook.initializeStructureData(this.base, this.field_75039_c);
        Long2ObjectMap<StructureStart> map = MapGenStructureHook.getStructureMap(this.base);
        LongOpenHashSet before = new LongOpenHashSet((LongCollection)map.keySet());
        this.base.func_186125_a(worldIn, x, z, primer);
        Sets.newHashSet((Iterable)Collections2.filter((Collection)map.keySet(), (Predicate)Predicates.not((Predicate)Predicates.in((Collection)before)))).forEach(key -> {
            StructureStart start = (StructureStart)map.get(key);
            if (start.func_75069_d()) {
                this.field_75038_b.setSeed(j * (long)start.func_143019_e() ^ k * (long)start.func_143018_f() ^ worldIn.func_72905_C());
                Pair<Structure<?>, VanillaDecorationGeneration> selected = RCBiomeDecorator.selectDecoration(server, this.field_75038_b, new BlockPos(start.func_143019_e() * 16, 0, start.func_143018_f() * 16), this.getDecorationType(start));
                if (selected != null) {
                    start.func_186161_c().clear();
                    MapGenStructureHook.setStructureStart(this.base, start.func_143019_e(), start.func_143018_f(), start);
                    RCBiomeDecorator.generate(selected, server, new ChunkPos(start.func_143019_e(), start.func_143018_f()), this.field_75038_b);
                }
            }
        });
    }

    public RCBiomeDecorator.DecorationType getDecorationType(StructureStart start) {
        return this.decorationType;
    }
}

