/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.operation;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import ivorius.ivtoolkit.lang.IvClasses;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.capability.RCEntityInfo;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.operation.Operation;
import ivorius.reccomplex.operation.OperationClearArea;
import ivorius.reccomplex.operation.OperationGenerateStructure;
import ivorius.reccomplex.utils.RCPacketBuffer;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class OperationRegistry {
    private static BiMap<String, Class<? extends Operation>> operations = HashBiMap.create();

    public static void register(String id, Class<? extends Operation> operation) {
        operations.put((Object)id, operation);
    }

    @Nullable
    public static Operation readOperation(@Nonnull NBTTagCompound compound) {
        String opID = compound.func_74779_i("opID");
        Class clazz = (Class)operations.get((Object)opID);
        if (clazz == null) {
            RecurrentComplex.logger.error(String.format("Unrecognized Operation ID '%s'", opID));
            return null;
        }
        return (Operation)NBTCompoundObjects.read((NBTTagCompound)compound, () -> (Operation)IvClasses.instantiate((Class)clazz));
    }

    public static NBTTagCompound writeOperation(@Nonnull Operation operation) {
        NBTTagCompound compound = NBTCompoundObjects.write((NBTCompoundObject)operation);
        compound.func_74778_a("opID", (String)operations.inverse().get(operation.getClass()));
        return compound;
    }

    public static boolean queueOperation(Operation operation, ICommandSender commandSender) throws CommandException {
        EntityPlayerMP player;
        RCEntityInfo info;
        if (operation.checkDead(commandSender)) {
            return false;
        }
        boolean instant = true;
        if (commandSender instanceof EntityPlayer && (info = RCEntityInfo.get(player = CommandBase.func_71521_c((ICommandSender)commandSender), null)) != null && info.getPreviewType() != Operation.PreviewType.NONE) {
            info.queueOperation(operation, (Entity)player);
            instant = false;
            TextComponentString confirmComponent = new TextComponentString("/" + RCCommands.confirm.func_71517_b());
            confirmComponent.func_150256_b().func_150238_a(TextFormatting.GREEN);
            confirmComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + RCCommands.confirm.func_71517_b()));
            confirmComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.get("commands.rcconfirm.run")));
            TextComponentString cancelComponent = new TextComponentString("/" + RCCommands.cancel.func_71517_b());
            cancelComponent.func_150256_b().func_150238_a(TextFormatting.RED);
            cancelComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + RCCommands.cancel.func_71517_b()));
            cancelComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, RecurrentComplex.translations.get("commands.rccancel.run")));
            commandSender.func_145747_a(RecurrentComplex.translations.format("commands.rc.queuedOp", confirmComponent, cancelComponent));
        }
        if (instant) {
            operation.perform((WorldServer)commandSender.func_130014_f_());
        }
        return true;
    }

    @Nullable
    public static NBTTagCompound dummyOperation(@Nonnull Operation operation, int level) {
        if (level == 0) {
            return OperationRegistry.writeOperation(operation);
        }
        if (operation instanceof OperationGenerateStructure) {
            OperationGenerateStructure genStructure = (OperationGenerateStructure)operation;
            if (level == 1 && genStructure.structure != null) {
                IvWorldData dummyWorldData = genStructure.structure.constructWorldData();
                dummyWorldData.entities.clear();
                dummyWorldData.tileEntities.clear();
                for (BlockPos pos : dummyWorldData.blockCollection.area()) {
                    dummyWorldData.blockCollection.setBlockState(pos, (dummyWorldData.blockCollection.getBlockState(pos).func_185915_l() ? Blocks.field_150348_b : Blocks.field_150350_a).func_176223_P());
                }
                GenericStructure dummyStructure = new GenericStructure();
                dummyStructure.worldDataCompound = dummyWorldData.createTagCompound();
                return OperationRegistry.writeOperation(genStructure.dummy(dummyStructure));
            }
            if (level == 2) {
                return OperationRegistry.writeOperation(new OperationClearArea(genStructure.generationArea()));
            }
        }
        return null;
    }

    public static void writeBestPreview(ByteBuf buffer, Operation operation) {
        NBTTagCompound nbt;
        if (operation == null) {
            ByteBufUtils.writeTag((ByteBuf)buffer, null);
            return;
        }
        int level = 0;
        while ((nbt = OperationRegistry.dummyOperation(operation, level++)) != null) {
            if (!OperationRegistry.canSend(nbt)) continue;
            new RCPacketBuffer(buffer).func_150786_a(nbt);
            return;
        }
        new RCPacketBuffer(buffer).func_150786_a(null);
    }

    protected static boolean canSend(NBTTagCompound danglingNBT) {
        ByteBuf temp = Unpooled.buffer();
        new RCPacketBuffer(temp).func_150786_a(danglingNBT);
        return OperationRegistry.canSend(temp);
    }

    protected static boolean canSend(ByteBuf temp) {
        return temp.writerIndex() <= 838860;
    }
}

