/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.item;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.RCGuiHandler;
import ivorius.reccomplex.item.GeneratingItem;
import ivorius.reccomplex.world.storage.loot.GenericItemCollectionRegistry;
import ivorius.reccomplex.world.storage.loot.GenericLootTable;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemLootTableComponentTag
extends Item
implements GeneratingItem {
    public ItemLootTableComponentTag() {
        this.func_77625_d(1);
    }

    public static String componentKey(ItemStack stack) {
        NBTTagCompound nbttagcompound;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("itemCollectionKey", 8)) {
            return stack.func_77978_p().func_74779_i("itemCollectionKey");
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("display", 10) && (nbttagcompound = stack.func_77978_p().func_74775_l("display")).func_150297_b("Name", 8)) {
            return nbttagcompound.func_74779_i("Name");
        }
        return null;
    }

    public static void setComponentKey(ItemStack stack, String generatorKey) {
        stack.func_77983_a("itemCollectionKey", (NBTBase)new NBTTagString(generatorKey));
    }

    public static GenericLootTable.Component component(ItemStack stack) {
        return (GenericLootTable.Component)((Object)GenericItemCollectionRegistry.INSTANCE.get(ItemLootTableComponentTag.componentKey(stack)));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStackIn = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            RCGuiHandler.editLootTableComponent(playerIn, ItemLootTableComponentTag.componentKey(itemStackIn), ItemLootTableComponentTag.component(itemStackIn), null);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public void generateInInventory(WorldServer server, IItemHandlerModifiable inventory, Random random, ItemStack stack, int fromSlot) {
        GenericLootTable.Component component = ItemLootTableComponentTag.component(stack);
        if (component != null) {
            inventory.setStackInSlot(fromSlot, component.getRandomItemStack(random));
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String func_77653_i(ItemStack stack) {
        String key = ItemLootTableComponentTag.componentKey(stack);
        return key != null ? key : super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        GenericLootTable.Component component = ItemLootTableComponentTag.component(stack);
        if (component != null) {
            tooltip.add(component.tableID);
            tooltip.add(GenericItemCollectionRegistry.INSTANCE.hasActive(ItemLootTableComponentTag.componentKey(stack)) ? IvTranslations.format((String)"inventoryGen.active", (Object[])new Object[]{TextFormatting.GREEN, TextFormatting.RESET}) : IvTranslations.format((String)"inventoryGen.inactive", (Object[])new Object[]{TextFormatting.RED, TextFormatting.RESET}));
        } else {
            tooltip.add(IvTranslations.get((String)"inventoryGen.create"));
        }
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        super.func_150895_a(tab, items);
        if (this.func_194125_a(tab)) {
            GenericItemCollectionRegistry.INSTANCE.ids().stream().sorted().forEach(key -> {
                ItemStack stack = new ItemStack((Item)this);
                ItemLootTableComponentTag.setComponentKey(stack, key);
                items.add((Object)stack);
            });
        }
    }
}

