/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.advanced_fishing.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.WorldServer;
import nightkosh.advanced_fishing.api.particles.IParticlesManager;
import nightkosh.advanced_fishing.api.particles.ISpawnBubbleParticles;
import nightkosh.advanced_fishing.api.particles.ISpawnSplashParticles;
import nightkosh.advanced_fishing.api.particles.ISpawnWakeParticles;

public class ParticlesManager
implements IParticlesManager {
    public static final ParticlesManager INSTANCE = new ParticlesManager();
    private static final Map<Block, ISpawnSplashParticles> SPLASH_PARTICLES = new HashMap<Block, ISpawnSplashParticles>();
    private static final Map<Block, ISpawnBubbleParticles> BUBBLE_PARTICLES = new HashMap<Block, ISpawnBubbleParticles>();
    private static final Map<Block, ISpawnWakeParticles> WAKE_PARTICLES = new HashMap<Block, ISpawnWakeParticles>();

    @Override
    public void addSplashParticles(Block block, ISpawnSplashParticles particles) {
        SPLASH_PARTICLES.put(block, particles);
    }

    @Override
    public ISpawnSplashParticles getSplashParticles(Block block) {
        return SPLASH_PARTICLES.getOrDefault(block, ParticlesManager::spawnWaterSplashParticles);
    }

    @Override
    public void addBubbleParticles(Block block, ISpawnBubbleParticles particles) {
        BUBBLE_PARTICLES.put(block, particles);
    }

    @Override
    public ISpawnBubbleParticles getBubbleParticles(Block block) {
        return BUBBLE_PARTICLES.getOrDefault(block, ParticlesManager::spawnWaterBubbleParticles);
    }

    @Override
    public void addWakeParticles(Block block, ISpawnWakeParticles particles) {
        WAKE_PARTICLES.put(block, particles);
    }

    @Override
    public ISpawnWakeParticles getWakeParticles(Block block) {
        return WAKE_PARTICLES.getOrDefault(block, ParticlesManager::spawnWaterWakeParticles);
    }

    private static void spawnWaterSplashParticles(WorldServer world, Random rand, double x, double y, double z) {
        world.func_175739_a(EnumParticleTypes.WATER_SPLASH, x, y, z, 2 + rand.nextInt(2), 0.1, 0.0, 0.1, 0.0, new int[0]);
    }

    private static void spawnLavaSplashParticles(WorldServer world, Random rand, double x, double y, double z) {
        int num = 2 + rand.nextInt(2);
        world.func_175739_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, num, 0.1, 0.0, 0.1, 0.0, new int[0]);
        world.func_175739_a(EnumParticleTypes.LAVA, x, y, z, num, 0.1, 0.0, 0.1, 0.0, new int[0]);
    }

    private static void spawnWaterBubbleParticles(WorldServer world, double x, double y, double z, int num, double xOffset, double yOffset, double zOffset, double speed) {
        world.func_175739_a(EnumParticleTypes.WATER_BUBBLE, x, y, z, num, xOffset, yOffset, zOffset, speed, new int[0]);
    }

    private static void spawnLavaBubbleParticles(WorldServer world, double x, double y, double z, int num, double xOffset, double yOffset, double zOffset, double speed) {
        world.func_175739_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, num, xOffset, yOffset, zOffset, speed, new int[0]);
    }

    private static void spawnWaterWakeParticles(WorldServer world, double x, double y, double z, int num, double xOffset, double yOffset, double zOffset, double speed) {
        world.func_175739_a(EnumParticleTypes.WATER_WAKE, x, y, z, num, xOffset, yOffset, zOffset, speed, new int[0]);
    }

    private static void spawnLavaWakeParticles(WorldServer world, double x, double y, double z, int num, double xOffset, double yOffset, double zOffset, double speed) {
        world.func_175739_a(EnumParticleTypes.SMOKE_LARGE, x, y, z, num, xOffset, yOffset, zOffset, speed, new int[0]);
        world.func_175739_a(EnumParticleTypes.LAVA, x, y, z, num, xOffset, yOffset, zOffset, speed, new int[0]);
    }

    static {
        SPLASH_PARTICLES.put((Block)Blocks.field_150355_j, ParticlesManager::spawnWaterSplashParticles);
        SPLASH_PARTICLES.put((Block)Blocks.field_150358_i, ParticlesManager::spawnWaterSplashParticles);
        SPLASH_PARTICLES.put((Block)Blocks.field_150353_l, ParticlesManager::spawnLavaSplashParticles);
        SPLASH_PARTICLES.put((Block)Blocks.field_150356_k, ParticlesManager::spawnLavaSplashParticles);
        BUBBLE_PARTICLES.put((Block)Blocks.field_150355_j, ParticlesManager::spawnWaterBubbleParticles);
        BUBBLE_PARTICLES.put((Block)Blocks.field_150358_i, ParticlesManager::spawnWaterBubbleParticles);
        BUBBLE_PARTICLES.put((Block)Blocks.field_150353_l, ParticlesManager::spawnLavaBubbleParticles);
        BUBBLE_PARTICLES.put((Block)Blocks.field_150356_k, ParticlesManager::spawnLavaBubbleParticles);
        WAKE_PARTICLES.put((Block)Blocks.field_150355_j, ParticlesManager::spawnWaterWakeParticles);
        WAKE_PARTICLES.put((Block)Blocks.field_150358_i, ParticlesManager::spawnWaterWakeParticles);
        WAKE_PARTICLES.put((Block)Blocks.field_150353_l, ParticlesManager::spawnLavaWakeParticles);
        WAKE_PARTICLES.put((Block)Blocks.field_150356_k, ParticlesManager::spawnLavaWakeParticles);
    }
}

