/*
 * Decompiled with CFR 0.152.
 */
package wiresegal.classyhats.event;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import wiresegal.classyhats.ClassyHats;
import wiresegal.classyhats.ClassyHatsConfig;
import wiresegal.classyhats.ClassyHatsContent;
import wiresegal.classyhats.capability.CapabilityHatContainer;
import wiresegal.classyhats.capability.data.ClassyHatProvider;
import wiresegal.classyhats.capability.data.IHatContainer;
import wiresegal.classyhats.item.ItemHat;
import wiresegal.classyhats.network.PacketEntityHatSync;
import wiresegal.classyhats.network.PacketHatSync;

@Mod.EventBusSubscriber(modid="classyhats")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001cH\u0007J\u0016\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lwiresegal/classyhats/event/CapabilityEvents;", "", "()V", "customKey", "", "getCustomKey", "()Ljava/lang/String;", "mapOfEntity", "Ljava/util/WeakHashMap;", "Lnet/minecraft/entity/EntityLiving;", "attachCapabilitiesPlayer", "", "event", "Lnet/minecraftforge/event/AttachCapabilitiesEvent;", "Lnet/minecraft/entity/Entity;", "cloneCapabilitiesEvent", "Lnet/minecraftforge/event/entity/player/PlayerEvent$Clone;", "onEntityJoinWorld", "Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;", "onLivingUpdate", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "onPlayerChangedDimension", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerChangedDimensionEvent;", "onPlayerLoggedIn", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerLoggedInEvent;", "onPlayerRespawn", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerRespawnEvent;", "onPlayerStartTracking", "Lnet/minecraftforge/event/entity/player/PlayerEvent$StartTracking;", "syncDataFor", "entity", "Lnet/minecraft/entity/player/EntityPlayer;", "to", "Lnet/minecraft/entity/player/EntityPlayerMP;", "classyhats"})
public final class CapabilityEvents {
    @NotNull
    private static final String customKey = "classyhats:hat";
    private static final WeakHashMap<EntityLiving, String> mapOfEntity;
    public static final CapabilityEvents INSTANCE;

    @SubscribeEvent
    @JvmStatic
    public static final void cloneCapabilitiesEvent(@NotNull PlayerEvent.Clone event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        try {
            EntityPlayer entityPlayer = event.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.original");
            IHatContainer bco = CapabilityHatContainer.Companion.getCapability(entityPlayer);
            NBTTagCompound nbt = (NBTTagCompound)bco.serializeNBT();
            EntityPlayer entityPlayer2 = event.getEntityPlayer();
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer2, (String)"event.entityPlayer");
            IHatContainer bcn = CapabilityHatContainer.Companion.getCapability(entityPlayer2);
            bcn.deserializeNBT((NBTBase)nbt);
        }
        catch (Exception e) {
            Logger logger = ClassyHats.Companion.getLOGGER();
            StringBuilder stringBuilder = new StringBuilder().append("Could not clone player [");
            EntityPlayer entityPlayer = event.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.original");
            logger.error(stringBuilder.append(entityPlayer.func_70005_c_()).append("] HATS when changing dimensions").toString());
        }
    }

    @SubscribeEvent
    @JvmStatic
    public static final void attachCapabilitiesPlayer(@NotNull AttachCapabilitiesEvent<Entity> event) {
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("classyhats", "container"), (ICapabilityProvider)new ClassyHatProvider(null, 1, null));
        }
    }

    @NotNull
    public final String getCustomKey() {
        return customKey;
    }

    @SubscribeEvent
    @JvmStatic
    public static final void onEntityJoinWorld(@NotNull EntityJoinWorldEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Entity entity = event.getEntity();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"event.entity");
        NBTTagCompound customData = entity.getEntityData();
        World world = event.getWorld();
        String name = String.valueOf(EntityList.func_191301_a((Entity)event.getEntity()));
        Entity entity2 = event.getEntity();
        if (ClassyHatsConfig.INSTANCE.getNames().contains(name) && world instanceof WorldServer && entity2 instanceof EntityLiving) {
            if (!customData.func_74764_b(customKey)) {
                List stack;
                List list = stack = ((WorldServer)world).func_184146_ak().func_186521_a(new ResourceLocation("classyhats", "combined")).func_186462_a(world.field_73012_v, new LootContext(0.0f, (WorldServer)world, ((WorldServer)world).func_184146_ak(), null, null, null));
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"stack");
                Collection collection = list;
                if (!collection.isEmpty() && world.field_73012_v.nextFloat() < ClassyHatsConfig.INSTANCE.getHatSpawnPercentage()) {
                    ItemHat itemHat = ClassyHatsContent.INSTANCE.getHAT();
                    Object e = stack.get(0);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"stack[0]");
                    customData.func_74778_a(customKey, itemHat.getHat((ItemStack)e).getName());
                } else {
                    customData.func_74778_a(customKey, "");
                }
            }
            mapOfEntity.put((EntityLiving)entity2, customData.func_74779_i(customKey));
        }
    }

    @SubscribeEvent
    @JvmStatic
    public static final void onLivingUpdate(@NotNull LivingEvent.LivingUpdateEvent event) {
        String prev;
        String hat;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Entity entity = event.getEntity();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"event.entity");
        NBTTagCompound customData = entity.getEntityData();
        Entity entity2 = event.getEntity();
        World world = entity2.field_70170_p;
        String name = String.valueOf(EntityList.func_191301_a((Entity)event.getEntity()));
        if (ClassyHatsConfig.INSTANCE.getNames().contains(name) && world instanceof WorldServer && entity2 instanceof EntityLiving && Intrinsics.areEqual((Object)(hat = customData.func_74779_i(customKey)), (Object)(prev = mapOfEntity.get(entity2))) ^ true) {
            mapOfEntity.put((EntityLiving)entity2, hat);
            Object object = CapabilityHatContainer.Companion.getEntry(entity2, (WorldServer)world);
            if (object != null && (object = object.field_73134_o) != null) {
                Iterable $receiver$iv = (Iterable)object;
                for (Object element$iv : $receiver$iv) {
                    EntityPlayerMP it = (EntityPlayerMP)element$iv;
                    int n = ((EntityLiving)entity2).func_145782_y();
                    String string = hat;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hat");
                    PacketHandler.NETWORK.sendTo((IMessage)new PacketEntityHatSync(n, string), it);
                }
            }
        }
    }

    @SubscribeEvent
    @JvmStatic
    public static final void onPlayerStartTracking(@NotNull PlayerEvent.StartTracking event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.getTarget() instanceof EntityPlayer) {
            Entity entity = event.getTarget();
            if (entity == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
            }
            EntityPlayer entityPlayer = event.getEntityPlayer();
            if (entityPlayer == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
            }
            INSTANCE.syncDataFor((EntityPlayer)entity, (EntityPlayerMP)entityPlayer);
        } else {
            Entity entity = event.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"event.target");
            NBTTagCompound data = entity.getEntityData();
            if (data.func_74764_b(customKey)) {
                Entity entity2 = event.getTarget();
                Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"event.target");
                int n = entity2.func_145782_y();
                String string = data.func_74779_i(customKey);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"data.getString(customKey)");
                EntityPlayer entityPlayer = event.getEntityPlayer();
                if (entityPlayer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
                }
                PacketHandler.NETWORK.sendTo((IMessage)new PacketEntityHatSync(n, string), (EntityPlayerMP)entityPlayer);
            }
        }
    }

    @SubscribeEvent
    @JvmStatic
    public static final void onPlayerLoggedIn(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        EntityPlayer entityPlayer = event.player;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.player");
        EntityPlayer entityPlayer2 = event.player;
        if (entityPlayer2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
        }
        INSTANCE.syncDataFor(entityPlayer, (EntityPlayerMP)entityPlayer2);
    }

    @SubscribeEvent
    @JvmStatic
    public static final void onPlayerChangedDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        EntityPlayer entityPlayer = event.player;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.player");
        EntityPlayer entityPlayer2 = event.player;
        if (entityPlayer2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
        }
        INSTANCE.syncDataFor(entityPlayer, (EntityPlayerMP)entityPlayer2);
    }

    @SubscribeEvent
    @JvmStatic
    public static final void onPlayerRespawn(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        EntityPlayer entityPlayer = event.player;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.player");
        EntityPlayer entityPlayer2 = event.player;
        if (entityPlayer2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
        }
        INSTANCE.syncDataFor(entityPlayer, (EntityPlayerMP)entityPlayer2);
    }

    public final void syncDataFor(@NotNull EntityPlayer entity, @NotNull EntityPlayerMP to) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        IHatContainer data = CapabilityHatContainer.Companion.getCapability(entity);
        NBTTagCompound hats = entity.func_145782_y() == to.func_145782_y() ? (NBTTagCompound)data.serializeNBT() : null;
        PacketHandler.NETWORK.sendTo((IMessage)new PacketHatSync(entity.func_145782_y(), data.getEquipped(), hats), to);
    }

    private CapabilityEvents() {
    }

    static {
        CapabilityEvents capabilityEvents;
        INSTANCE = capabilityEvents = new CapabilityEvents();
        customKey = customKey;
        mapOfEntity = new WeakHashMap();
    }
}

