/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.event;

import com.elenai.elenaidodge.ModConfig;
import com.elenai.elenaidodge.api.DodgeEvent;
import com.elenai.elenaidodge.capability.airborne.AirborneProvider;
import com.elenai.elenaidodge.capability.airborne.IAirborne;
import com.elenai.elenaidodge.capability.enabled.EnabledProvider;
import com.elenai.elenaidodge.capability.enabled.IEnabled;
import com.elenai.elenaidodge.init.PotionInit;
import com.elenai.elenaidodge.network.PacketHandler;
import com.elenai.elenaidodge.network.message.CUpdateCooldownMessage;
import com.elenai.elenaidodge.util.Utils;
import com.elenai.elenaidodge.util.WeightTier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerDodgeEventListener {
    @SubscribeEvent
    public void onServerDodge(DodgeEvent.ServerDodgeEvent event) {
        IEnabled e;
        EntityPlayer player = event.getPlayer();
        if (ModConfig.common.weights.enable) {
            WeightTier weightTier = Utils.getWeightTier(player);
            event.setForce(weightTier.getForce());
            PacketHandler.instance.sendTo((IMessage)new CUpdateCooldownMessage(Utils.getWeightTier(player).getCooldown()), (EntityPlayerMP)player);
        }
        IAirborne a = (IAirborne)player.getCapability(AirborneProvider.AIRBORNE_CAP, null);
        if (!(player.field_70122_E || ModConfig.common.balance.enableWhilstAirborne || player.func_70644_a(PotionInit.SKYSTRIDE_EFFECT) || Utils.hasAirborneGamestage(player) || a.isEnabled())) {
            event.setCanceled(true);
        }
        if (ModConfig.common.gamestages.enable && !Utils.hasGamestage(player)) {
            event.setCanceled(true);
        }
        if (!(e = (IEnabled)player.getCapability(EnabledProvider.ENABLED_CAP, null)).isEnabled()) {
            event.setCanceled(true);
        }
        if (player.func_70644_a(PotionInit.SLUGGISH_EFFECT)) {
            event.setCanceled(true);
        }
        if (ModConfig.common.balance.requiresPotion && !player.func_70644_a(PotionInit.CAN_DODGE_EFFECT)) {
            event.setCanceled(true);
        }
        if (!Utils.dodgeTraitUnlocked(player)) {
            event.setCanceled(true);
        }
        if (player.func_71024_bL().func_75116_a() <= ModConfig.common.balance.hunger) {
            event.setCanceled(true);
        }
        if (player.func_70093_af() && !ModConfig.common.balance.enableWhilstSneaking) {
            event.setCanceled(true);
        }
        if (player.func_184585_cz() && !ModConfig.common.balance.enableWhilstBlocking) {
            event.setCanceled(true);
        }
        if (player.func_184218_aH()) {
            event.setCanceled(true);
        }
        if (!player.func_184812_l_() && !player.func_175149_v() && event.getCooldown() > 0) {
            event.setCanceled(true);
        }
        for (String i : ModConfig.common.balance.potions) {
            player.func_70651_bq().forEach(p -> {
                if (p.func_188419_a().getRegistryName().equals((Object)new ResourceLocation(i))) {
                    event.setCanceled(true);
                }
            });
        }
        if (player.func_70644_a(MobEffects.field_76421_d)) {
            event.setForce(event.getForce() / (double)(player.func_70660_b(MobEffects.field_76421_d).func_76458_c() + 2));
            if (player.func_70660_b(MobEffects.field_76421_d).func_76458_c() > 5) {
                event.setCanceled(true);
            }
        }
        if (player.field_71093_bK == -1 && ModConfig.common.misc.nether) {
            event.setForce(event.getForce() * 1.25);
        }
        if (player.field_71093_bK == 1 && ModConfig.common.misc.end) {
            event.setForce(event.getForce() / 1.25);
        }
        if (player.func_70644_a(PotionInit.FORCEFUL_EFFECT)) {
            event.setForce(event.getForce() + ((double)player.func_70660_b(PotionInit.FORCEFUL_EFFECT).func_76458_c() + 0.3) / 2.0);
        }
        if (player.func_70644_a(PotionInit.FEEBLE_EFFECT)) {
            event.setForce(event.getForce() / (double)(player.func_70660_b(PotionInit.FEEBLE_EFFECT).func_76458_c() + 2));
        }
        if (event.getForce() <= 0.0) {
            event.setCanceled(true);
        }
    }
}

