/*
 * Decompiled with CFR 0.152.
 */
package c4.comforts.common;

import c4.comforts.Comforts;
import c4.comforts.common.ConfigHandler;
import c4.comforts.common.blocks.BlockHammock;
import c4.comforts.common.blocks.BlockSleepingBag;
import c4.comforts.common.entities.EntityRest;
import c4.comforts.common.tileentities.TileEntityHammock;
import c4.comforts.common.util.ComfortsUtil;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Level;

public class EventHandlerCommon {
    public static final Method WAKE_ALL_PLAYERS = ReflectionHelper.findMethod(WorldServer.class, (String)"wakeAllPlayers", (String)"func_73053_d", (Class[])new Class[0]);

    @SubscribeEvent
    public void onPreWorldTick(TickEvent.WorldTickEvent evt) {
        WorldServer world;
        if (evt.phase == TickEvent.Phase.START && evt.world instanceof WorldServer && (world = (WorldServer)evt.world).func_73056_e()) {
            boolean skipToNight = false;
            if (world.func_82736_K().func_82766_b("doDaylightCycle")) {
                for (EntityPlayer entityplayer : world.field_73010_i) {
                    BlockPos bedLocation = entityplayer.field_71081_bT;
                    if (!entityplayer.func_71026_bH() || bedLocation == null || !(world.func_180495_p(bedLocation).func_177230_c() instanceof BlockHammock)) continue;
                    long i = world.func_72820_D() + 24000L;
                    long worldTime = world.func_72820_D() % 24000L;
                    if (worldTime <= 500L || worldTime >= 11500L) break;
                    skipToNight = true;
                    world.func_72877_b(i - i % 24000L - 12001L);
                    break;
                }
            }
            if (skipToNight) {
                try {
                    WAKE_ALL_PLAYERS.invoke((Object)world, new Object[0]);
                }
                catch (Exception e) {
                    Comforts.logger.log(Level.ERROR, "Error trying to wake all players!" + e.getMessage());
                }
            }
        }
    }

    @SubscribeEvent
    public void allowDaytimeNapping(SleepingTimeCheckEvent evt) {
        World world = evt.getEntityPlayer().func_130014_f_();
        long worldTime = world.func_72820_D() % 24000L;
        if (world.func_180495_p(evt.getSleepingLocation()).func_177230_c() instanceof BlockHammock) {
            if (worldTime > 500L && worldTime < 11500L) {
                evt.setResult(Event.Result.ALLOW);
            } else if (ConfigHandler.nightHammocks) {
                evt.setResult(Event.Result.DEFAULT);
            } else {
                evt.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void stopResting(EntityMountEvent evt) {
        Entity entity;
        if (evt.isDismounting() && (entity = evt.getEntityBeingMounted()) instanceof EntityRest) {
            TileEntity tileentity = evt.getWorldObj().func_175625_s(entity.func_180425_c());
            if (tileentity instanceof TileEntityHammock) {
                TileEntityHammock tileentityhammock = (TileEntityHammock)tileentity;
                tileentityhammock.setOccupied(false);
            }
            entity.func_70106_y();
        }
    }

    @SubscribeEvent
    public void onPlayerSetSpawn(PlayerSetSpawnEvent evt) {
        World world = evt.getEntityPlayer().func_130014_f_();
        if (evt.getNewSpawn() != null) {
            Block block = world.func_180495_p(evt.getNewSpawn()).func_177230_c();
            if (!world.field_72995_K && (block instanceof BlockSleepingBag || block instanceof BlockHammock)) {
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerWakeUp(PlayerWakeUpEvent evt) {
        BlockPos pos;
        IBlockState state;
        EntityPlayer player = evt.getEntityPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K && player.field_71081_bT != null && (state = player.field_70170_p.func_180495_p(pos = player.field_71081_bT)).func_177230_c() instanceof BlockSleepingBag) {
            if (!ComfortsUtil.getDebuffs().isEmpty()) {
                ComfortsUtil.applyDebuffs(player);
            }
            if (ConfigHandler.bagBreakPerc > world.field_73012_v.nextDouble()) {
                BlockPos pos1 = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockSleepingBag.field_185512_D)).func_176734_d());
                world.func_175698_g(pos);
                world.func_175698_g(pos1);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.sleeping_bag.broke", new Object[0]), true);
                world.func_184133_a(null, pos, SoundEvents.field_187546_ae, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

