/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.shared;

import com.google.common.eventbus.Subscribe;
import javax.annotation.Nonnull;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.recipes.InspirationsRecipes;
import knightminer.inspirations.shared.InspirationsShared;
import knightminer.inspirations.utility.InspirationsUtility;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="InspirationsShared", description="Blocks and items used by all modules", forced=true)
public class InspirationsOredict {
    private static final String[] DYES = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};

    @Subscribe
    public void doTheOredict(FMLInitializationEvent event) {
        this.ensureVanilla();
        InspirationsOredict.registerBuilding();
        InspirationsOredict.registerRecipes();
        this.registerShared();
        InspirationsOredict.registerUtility();
    }

    private void ensureVanilla() {
        InspirationsOredict.oredict(Items.field_151122_aG, "book");
        InspirationsOredict.oredict(Blocks.field_150415_aT, "trapdoorWood");
        InspirationsOredict.oredict((Block)Blocks.field_150337_Q, "mushroomAny");
        InspirationsOredict.oredict((Block)Blocks.field_150338_P, "mushroomAny");
    }

    private void registerShared() {
        InspirationsOredict.oredict(InspirationsShared.witherBone, "boneWithered");
        InspirationsOredict.oredict(InspirationsShared.stoneRod, "rodStone");
    }

    private static void registerBuilding() {
        InspirationsOredict.oredict((Item)InspirationsBuilding.books, "book");
    }

    private static void registerRecipes() {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            InspirationsOredict.oredict((Item)InspirationsRecipes.dyedWaterBottle, color.func_176767_b(), InspirationsOredict.dyeNameFor(color));
        }
        InspirationsOredict.oredict(InspirationsShared.splashBottle, "bottleSplash");
        InspirationsOredict.oredict(InspirationsShared.lingeringBottle, "bottleLingering");
    }

    private static void registerUtility() {
        if (InspirationsUtility.carpetedTrapdoors != null) {
            for (Block block : InspirationsUtility.carpetedTrapdoors) {
                InspirationsOredict.oredict(block, "trapdoorCarpeted");
            }
        }
    }

    public static String dyeNameFor(@Nonnull EnumDyeColor color) {
        return "dye" + DYES[color.func_176765_a()];
    }

    public static void oredict(Item item, String ... name) {
        InspirationsOredict.oredict(item, Short.MAX_VALUE, name);
    }

    public static void oredict(Block block, String ... name) {
        InspirationsOredict.oredict(block, Short.MAX_VALUE, name);
    }

    public static void oredict(Item item, int meta, String ... name) {
        InspirationsOredict.oredict(new ItemStack(item, 1, meta), name);
    }

    public static void oredict(Block block, int meta, String ... name) {
        InspirationsOredict.oredict(new ItemStack(block, 1, meta), name);
    }

    public static void oredict(ItemStack stack, String ... names) {
        if (stack != null && !stack.func_190926_b()) {
            for (String name : names) {
                OreDictionary.registerOre((String)name, (ItemStack)stack);
            }
        }
    }
}

