/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei.cauldron.ingredient;

import java.util.ArrayList;
import java.util.List;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.plugins.jei.cauldron.CauldronRecipeCategory;
import knightminer.inspirations.plugins.jei.cauldron.ingredient.PotionIngredient;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;

public enum PotionIngredientRenderer implements IIngredientRenderer<PotionIngredient>
{
    INVENTORY,
    LEVEL_1,
    LEVEL_2,
    LEVEL_3,
    LEVEL_4,
    INVALID;

    private int level = this.ordinal();
    public static final ResourceLocation POTION_TEXTURE;

    public static PotionIngredientRenderer forLevel(int level) {
        if (level < 1 || level > 4 || level == 4 && !Config.enableBiggerCauldron) {
            return INVALID;
        }
        return PotionIngredientRenderer.values()[level];
    }

    public void render(Minecraft minecraft, int x, int y, PotionIngredient potion) {
        if (potion == null || this.level == PotionIngredientRenderer.INVALID.level) {
            return;
        }
        float[] color = Util.getColorComponents(PotionUtils.func_185183_a((PotionType)potion.getPotion()));
        ClientUtil.renderJEICauldronFluid(minecraft, x, y, POTION_TEXTURE, color, this.level);
    }

    public List<String> getTooltip(Minecraft minecraft, PotionIngredient ingredient, ITooltipFlag tooltipFlag) {
        ArrayList<String> tooltip = new ArrayList<String>();
        PotionType potion = ingredient.getPotion();
        tooltip.add(Util.translate(potion.func_185174_b("potion.effect."), new Object[0]));
        Util.addPotionTooltip(potion, tooltip);
        CauldronRecipeCategory.addLevelTooltip(this.level, tooltip);
        return tooltip;
    }

    static {
        POTION_TEXTURE = Util.getResource("blocks/fluid_potion");
    }
}

