/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.roguelike.loot.special.weapons.SpecialBow;
import com.github.fnar.roguelike.loot.special.weapons.SpecialSword;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.LootItem;
import greymerk.roguelike.treasure.loot.provider.SpecialtyLootItem;
import java.util.Optional;
import java.util.Random;

public class WeaponLootItem
extends LootItem {
    private Equipment type;
    private boolean isEnchanted;
    private Quality quality;

    public WeaponLootItem(int weight, int level) {
        super(weight, level);
    }

    public WeaponLootItem(int weight, int level, Equipment type, Quality quality, boolean isEnchanted) {
        super(weight, level);
        this.type = type;
        this.isEnchanted = isEnchanted;
        this.quality = quality;
    }

    @Override
    public RldItemStack getLootItem(Random random) {
        return SpecialtyLootItem.rollForSpecial(random) ? this.createSpecialWeapon(random) : Equipment.asWeaponType(this.getType(random)).asItem().withQuality(this.getQuality(random)).plzEnchantAtLevel(this.getEnchantLevel(random, this.level)).asStack();
    }

    private RldItemStack createSpecialWeapon(Random random) {
        return random.nextBoolean() ? SpecialBow.newSpecialBow(random, this.getQuality(random)).asStack() : SpecialSword.newSpecialSword(random, this.getQuality(random)).asStack();
    }

    private Equipment getType(Random random) {
        return Optional.ofNullable(this.type).orElseGet(() -> random.nextInt(8) == 0 ? Equipment.BOW : Equipment.SWORD);
    }

    private Quality getQuality(Random random) {
        return Optional.ofNullable(this.quality).orElseGet(() -> Equipment.rollQuality(random, this.level));
    }

    private int getEnchantLevel(Random random, int level) {
        return this.isEnchanted ? LootItem.getEnchantmentLevel(random, level) : 0;
    }
}

