/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.item.mapper;

import com.github.fnar.minecraft.item.CouldNotMapItemException;
import com.github.fnar.minecraft.item.ItemMapper;
import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.minecraft.tag.CompoundTag;
import com.github.fnar.minecraft.tag.TagMapper1_12;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public abstract class BaseItemMapper1_12<ItemClass>
implements ItemMapper {
    private static final TagMapper1_12 tagMapper = new TagMapper1_12();

    public abstract Class<ItemClass> getClazz();

    @Override
    public ItemStack map(RldItemStack rldItemStack) {
        Class<ItemClass> clazz = this.getClazz();
        if (!clazz.isAssignableFrom(rldItemStack.getItem().getClass())) {
            throw new CouldNotMapItemException(rldItemStack);
        }
        ItemStack itemStack = this.map(this.getClazz().cast(rldItemStack.getItem()));
        itemStack.func_77964_b(rldItemStack.getDamage());
        itemStack.func_190920_e(rldItemStack.getCount());
        BaseItemMapper1_12.mapPlzNbt(rldItemStack, itemStack);
        BaseItemMapper1_12.mergeTags(rldItemStack, itemStack);
        return itemStack;
    }

    public abstract ItemStack map(ItemClass var1);

    private static void mapPlzNbt(RldItemStack rldItemStack, ItemStack itemStack) {
        if (!rldItemStack.isPlzNbt()) {
            return;
        }
        try {
            itemStack.func_77982_d(JsonToNBT.func_180713_a((String)rldItemStack.getPlzNbt()));
        }
        catch (NBTException e) {
            throw new CouldNotMapItemException(rldItemStack);
        }
    }

    private static void mergeTags(RldItemStack rldItemStack, ItemStack itemStack) {
        Optional.ofNullable(rldItemStack.getTags()).ifPresent(compoundTag -> Optional.ofNullable(itemStack.func_77978_p()).orElseGet(() -> BaseItemMapper1_12.ensureNbtTags(itemStack)).func_179237_a(tagMapper.map((CompoundTag)compoundTag)));
    }

    private static NBTTagCompound ensureNbtTags(ItemStack itemStack) {
        itemStack.func_77982_d(new NBTTagCompound());
        return itemStack.func_77978_p();
    }
}

