/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;

public final class ItemStackDef {
    public Item item = Items.field_190931_a;
    public int meta = 0;
    public int count = 1;
    private String _item_resource = null;
    public static final ItemStackDef EMPTY = new ItemStackDef();
    public static final ItemStackDef UNUSED = new ItemStackDef(Items.field_151124_az, 123, 0);

    public ItemStackDef() {
    }

    public ItemStackDef(Item obj, int num, int id) {
        this.item = obj;
        this.meta = id;
        this.count = num;
    }

    public ItemStackDef(Item obj, int num) {
        this.item = obj;
        this.count = num;
    }

    public ItemStackDef(Item obj) {
        this.item = obj;
    }

    public ItemStackDef(Block obj, int num, int id) {
        this(Item.func_150898_a((Block)obj), num, id);
    }

    public ItemStackDef(Block obj, int num) {
        this(Item.func_150898_a((Block)obj), num);
    }

    public ItemStackDef(Block obj) {
        this(Item.func_150898_a((Block)obj));
    }

    public ItemStackDef(@Nonnull ItemStack obj) {
        this(obj.func_77973_b(), obj.func_190916_E(), obj.func_77960_j());
    }

    public ItemStackDef(String rid, int num, int id) {
        Validate.notBlank((CharSequence)rid, (String)"A non-blank item resource name is required", (Object[])new Object[0]);
        this._item_resource = rid;
        this.item = null;
        this.count = num;
        this.meta = id;
    }

    private ItemStackDef(Item obj, int num, int id, String rid) {
        this(obj, num, id);
        this._item_resource = rid;
    }

    public final Item getItem() {
        return this.item;
    }

    public final int getMetadata() {
        return this.meta;
    }

    public final int getCount() {
        return this.count;
    }

    public final ItemStackDef copy() {
        return new ItemStackDef(this.item, this.count, this.meta, this._item_resource);
    }

    public final ItemStack get() {
        return this == EMPTY ? ItemStack.field_190927_a : (this.item != null ? new ItemStack(this.item, this.count, this.meta) : (this._item_resource != null ? this.getnamed() : ItemStack.field_190927_a));
    }

    public final ItemStack safeget() {
        try {
            return this.get();
        }
        catch (RuntimeException unregistered) {
            return ItemStack.field_190927_a;
        }
    }

    private final ItemStack getnamed() {
        Item registered = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this._item_resource));
        if (registered != null) {
            this.item = registered;
            return new ItemStack(this.item, this.count, this.meta);
        }
        return ItemStack.field_190927_a;
    }

    public final boolean isEmpty() {
        return this == EMPTY || this.item == null && this._item_resource == null || this.item == Items.field_190931_a || this.count <= 0;
    }

    public static final boolean isEmpty(ItemStackDef o) {
        return o == null || o.isEmpty();
    }

    public final boolean isSingle() {
        return this.count == 1 && !this.isEmpty();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "*EMPTY*";
        }
        String itemstring = ClassUtils.getShortCanonicalName((Object)this.item, (String)"null");
        return "{[@]" + this.meta + ",[#]" + this.count + ",[o]" + itemstring + "}";
    }

    @Nonnull
    public static final ItemStack convert(@Nullable Object o) {
        if (o == null) {
            return ItemStack.field_190927_a;
        }
        if (o instanceof ItemStack) {
            return (ItemStack)o;
        }
        assert (o instanceof ItemStackDef);
        return ((ItemStackDef)o).safeget();
    }

    public static final ItemStackDef copy(@Nullable ItemStackDef from) {
        if (from == null || from.isEmpty()) {
            return EMPTY;
        }
        return from.copy();
    }
}

