/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.world.biome.BiomeColorHelper;

public class ColorResolverCompatibility {
    public static final Lock lock = new ReentrantLock();
    public static final HashMap<BiomeColorHelper.ColorResolver, Integer> knownColorResolvers = new HashMap();
    public static int nextColorID = 3;

    public static int addNewColorResolver(BiomeColorHelper.ColorResolver colorResolver) {
        lock.lock();
        int id = nextColorID++;
        knownColorResolvers.put(colorResolver, id);
        lock.unlock();
        return id;
    }

    public static int getColorResolverID(BiomeColorHelper.ColorResolver colorResolver) {
        Integer id = knownColorResolvers.get(colorResolver);
        if (id == null) {
            id = ColorResolverCompatibility.addNewColorResolver(colorResolver);
        }
        return id;
    }

    static {
        knownColorResolvers.put(BiomeColorHelper.field_180291_a, 0);
        knownColorResolvers.put(BiomeColorHelper.field_180290_c, 1);
        knownColorResolvers.put(BiomeColorHelper.field_180289_b, 2);
    }
}

