/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.temperature;

import com.charles445.simpledifficulty.api.temperature.ITemperatureModifier;
import com.charles445.simpledifficulty.api.temperature.TemperatureEnum;
import com.charles445.simpledifficulty.config.ModConfig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class ModifierBase
implements ITemperatureModifier {
    private final String name;
    protected final float defaultTemperature;

    protected ModifierBase(String name) {
        this.name = name;
        this.defaultTemperature = (TemperatureEnum.NORMAL.getUpperBound() + TemperatureEnum.COLD.getUpperBound()) / 2;
    }

    @Override
    public float getPlayerInfluence(EntityPlayer player) {
        return 0.0f;
    }

    @Override
    public float getWorldInfluence(World world, BlockPos pos) {
        return 0.0f;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected float applyUndergroundEffect(float temperature, World world, BlockPos pos) {
        if (pos.func_177956_o() >= 64) {
            return temperature;
        }
        if (!ModConfig.server.temperature.undergroundEffect || !world.field_73011_w.func_76569_d()) {
            return temperature;
        }
        if (world.func_175678_i(pos) || world.func_175678_i(pos.func_177984_a())) {
            return temperature;
        }
        int cutoff = ModConfig.server.temperature.undergroundEffectCutoff;
        if (pos.func_177956_o() <= cutoff || cutoff == 64) {
            return 0.0f;
        }
        return temperature * (float)(pos.func_177956_o() - cutoff) / (64.0f - (float)cutoff);
    }

    protected float getTempForBiome(Biome biome) {
        return MathHelper.func_76131_a((float)biome.func_185353_n(), (float)0.0f, (float)1.35f) / 1.35f;
    }

    protected float normalizeToPlusMinus(float value) {
        return value * 2.0f - 1.0f;
    }
}

