/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.handler;

import com.charles445.simpledifficulty.api.SDCapabilities;
import com.charles445.simpledifficulty.api.SDPotions;
import com.charles445.simpledifficulty.api.config.JsonConfig;
import com.charles445.simpledifficulty.api.config.QuickConfig;
import com.charles445.simpledifficulty.api.config.json.JsonConsumableThirst;
import com.charles445.simpledifficulty.api.thirst.IThirstCapability;
import com.charles445.simpledifficulty.api.thirst.ThirstEnum;
import com.charles445.simpledifficulty.api.thirst.ThirstUtil;
import com.charles445.simpledifficulty.compat.CompatRightClick;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.network.MessageDrinkWater;
import com.charles445.simpledifficulty.network.PacketHandler;
import com.charles445.simpledifficulty.util.SoundUtil;
import com.charles445.simpledifficulty.util.internal.ThirstUtilInternal;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ThirstHandler {
    private final boolean harvestcraftLoaded = Loader.isModLoaded((String)"harvestcraft");

    @SubscribeEvent
    public void onLivingEntityUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        if (!QuickConfig.isThirstEnabled()) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            PotionType potionType;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            ItemStack stack = event.getItem();
            List<JsonConsumableThirst> consumableList = JsonConfig.consumableThirst.get(stack.func_77973_b().getRegistryName().toString());
            if (consumableList != null) {
                for (JsonConsumableThirst jct : consumableList) {
                    if (jct == null || !jct.matches(stack)) continue;
                    ThirstUtil.takeDrink(player, jct.amount, jct.saturation, jct.thirstyChance);
                    return;
                }
            }
            if (stack.func_77973_b().equals(Items.field_151068_bn) && (potionType = PotionUtils.func_185191_c((ItemStack)stack)).getRegistryName() != null) {
                String modDomain = potionType.getRegistryName().func_110624_b();
                if (modDomain.equals("minecraft")) {
                    if (potionType.equals(PotionTypes.field_185230_b) || potionType.equals(PotionTypes.field_185233_e) || potionType.equals(PotionTypes.field_185231_c) || potionType.equals(PotionTypes.field_185232_d)) {
                        ThirstUtil.takeDrink(player, ThirstEnum.NORMAL);
                        return;
                    }
                    if (!potionType.equals(PotionTypes.field_185229_a)) {
                        ThirstUtil.takeDrink(player, ThirstEnum.POTION);
                        return;
                    }
                } else if (SDPotions.potionTypes.containsValue(potionType)) {
                    ThirstUtil.takeDrink(player, ThirstEnum.POTION);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!QuickConfig.isThirstEnabled()) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            if (event.getHand() == EnumHand.MAIN_HAND && this.clientCheckWater(event.getEntityPlayer())) {
                this.clientSendDrinkMessageAndPlaySound(event.getEntityPlayer());
            }
        } else {
            BlockPos pos;
            World world;
            IBlockState state;
            EntityPlayer player = event.getEntityPlayer();
            EnumHand hand = event.getHand();
            if (hand == EnumHand.MAIN_HAND && (state = (world = event.getWorld()).func_180495_p(pos = event.getPos())).func_177230_c() == Blocks.field_150383_bp) {
                CompatRightClick.cauldronHandler.process(event, world, pos, state, player);
            }
        }
    }

    @SubscribeEvent
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (!QuickConfig.isThirstEnabled()) {
            return;
        }
        if (event.getHand() == EnumHand.MAIN_HAND && this.clientCheckWater(event.getEntityPlayer())) {
            this.clientSendDrinkMessageAndPlaySound(event.getEntityPlayer());
        }
    }

    private boolean clientCheckWater(EntityPlayer player) {
        if (!player.func_70093_af() || !QuickConfig.isThirstEnabled()) {
            return false;
        }
        return ThirstUtilInternal.traceWaterToDrink(player) != null;
    }

    private void clientSendDrinkMessageAndPlaySound(EntityPlayer player) {
        MessageDrinkWater message = new MessageDrinkWater();
        PacketHandler.instance.sendToServer((IMessage)message);
        player.func_184609_a(EnumHand.MAIN_HAND);
        SoundUtil.commonPlayPlayerSound(player, SoundEvents.field_187664_bz);
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        Entity monster;
        if (!QuickConfig.isThirstEnabled()) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (!this.shouldSkipThirst(player) && (monster = event.getTarget()).func_70075_an() && !monster.func_85031_j((Entity)player)) {
            this.addExhaustion(player, (float)ModConfig.server.thirst.thirstAttacking);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!QuickConfig.isThirstEnabled()) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (!this.shouldSkipThirst(player) && event.getState().func_177230_c().canHarvestBlock((IBlockAccess)world, event.getPos(), player)) {
            this.addExhaustion(player, (float)ModConfig.server.thirst.thirstBreakBlock);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EntityPlayer player;
        if (!QuickConfig.isThirstEnabled()) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        if (world.field_72995_K || event.getAmount() == 0.0f) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer && !this.shouldSkipThirst(player = (EntityPlayer)event.getEntity())) {
            this.addExhaustion(player, event.getSource().func_76345_d());
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        if (!QuickConfig.isThirstEnabled()) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer && !this.shouldSkipThirst(player = (EntityPlayer)event.getEntity())) {
            if (player.func_70051_ag()) {
                this.addExhaustion(player, (float)ModConfig.server.thirst.thirstSprintJump);
            } else {
                this.addExhaustion(player, (float)ModConfig.server.thirst.thirstJump);
            }
        }
    }

    private boolean shouldSkipThirst(EntityPlayer player) {
        return player.func_184812_l_() || player.func_175149_v();
    }

    private void addExhaustion(EntityPlayer player, float exhaustion) {
        IThirstCapability capability = SDCapabilities.getThirstData(player);
        capability.addThirstExhaustion(exhaustion);
    }
}

