/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.block;

import com.charles445.simpledifficulty.api.SDCapabilities;
import com.charles445.simpledifficulty.api.SDItems;
import com.charles445.simpledifficulty.api.item.IItemCanteen;
import com.charles445.simpledifficulty.api.thirst.ThirstEnum;
import com.charles445.simpledifficulty.api.thirst.ThirstUtil;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.util.SoundUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRainCollector
extends Block {
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)3);

    public BlockRainCollector() {
        super(Material.field_151573_f, MapColor.field_151665_m);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149675_a(true);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_73012_v.nextInt(Math.max(1, ModConfig.server.miscellaneous.rainCollectorFillChance)) == 0 && world.func_175727_C(pos.func_177984_a())) {
            IBlockState iblockstate;
            float f = world.func_180494_b(pos).func_180626_a(pos);
            if (world.func_72959_q().func_76939_a(f, pos.func_177956_o()) >= 0.15f && (Integer)(iblockstate = world.func_180495_p(pos)).func_177229_b((IProperty)LEVEL) < 3) {
                world.func_180501_a(pos, iblockstate.func_177231_a((IProperty)LEVEL), 2);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_190926_b()) {
            int amount;
            if (player.func_70093_af() && (amount = ((Integer)state.func_177229_b((IProperty)LEVEL)).intValue()) > 0 && SDCapabilities.getThirstData(player).isThirsty()) {
                SoundUtil.commonPlayPlayerSound(player, SoundEvents.field_187664_bz);
                if (!world.field_72995_K) {
                    this.setWaterLevel(world, pos, state, amount - 1);
                    ThirstUtil.takeDrink(player, ThirstEnum.PURIFIED);
                }
            }
            return true;
        }
        int amount = (Integer)state.func_177229_b((IProperty)LEVEL);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151133_ar) {
            if (amount > 0 && !world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                    if (itemstack.func_190926_b()) {
                        player.func_184611_a(hand, ThirstUtil.createPurifiedWaterBucket());
                    } else if (!player.field_71071_by.func_70441_a(ThirstUtil.createPurifiedWaterBucket())) {
                        player.func_71019_a(ThirstUtil.createPurifiedWaterBucket(), false);
                    }
                }
                this.setWaterLevel(world, pos, state, amount - 1);
                SoundUtil.serverPlayBlockSound(world, pos, SoundEvents.field_187630_M);
            }
            return true;
        }
        if (item == Items.field_151069_bo) {
            if (amount > 0 && !world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(SDItems.purifiedWaterBottle));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack(SDItems.purifiedWaterBottle))) {
                    player.func_71019_a(new ItemStack(SDItems.purifiedWaterBottle), false);
                } else if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
                this.setWaterLevel(world, pos, state, amount - 1);
                SoundUtil.serverPlayBlockSound(world, pos, SoundEvents.field_187615_H);
            }
            return true;
        }
        if (item == SDItems.canteen) {
            if (amount > 0 && !world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                IItemCanteen canteen = (IItemCanteen)item;
                ThirstEnum type = canteen.getThirstEnum(itemstack);
                if (canteen.tryAddDose(itemstack, ThirstEnum.PURIFIED)) {
                    this.setWaterLevel(world, pos, state, amount - 1);
                    SoundUtil.serverPlayBlockSound(world, pos, SoundEvents.field_187630_M);
                }
            }
            return true;
        }
        return false;
    }

    public void setWaterLevel(World world, BlockPos pos, IBlockState state, int level) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)level, (int)0, (int)3))), 2);
        world.func_175666_e(pos, (Block)this);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((IProperty)LEVEL);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LEVEL);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

