/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.api.config;

import com.charles445.simpledifficulty.api.config.json.JsonConsumableTemperature;
import com.charles445.simpledifficulty.api.config.json.JsonConsumableThirst;
import com.charles445.simpledifficulty.api.config.json.JsonItemIdentity;
import com.charles445.simpledifficulty.api.config.json.JsonPropertyTemperature;
import com.charles445.simpledifficulty.api.config.json.JsonPropertyValue;
import com.charles445.simpledifficulty.api.config.json.JsonTemperature;
import com.charles445.simpledifficulty.api.config.json.JsonTemperatureIdentity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class JsonConfig {
    public static Map<String, List<JsonTemperatureIdentity>> armorTemperatures = new HashMap<String, List<JsonTemperatureIdentity>>();
    public static Map<String, List<JsonPropertyTemperature>> blockTemperatures = new HashMap<String, List<JsonPropertyTemperature>>();
    public static Map<String, List<JsonConsumableTemperature>> consumableTemperature = new HashMap<String, List<JsonConsumableTemperature>>();
    public static Map<String, List<JsonConsumableThirst>> consumableThirst = new HashMap<String, List<JsonConsumableThirst>>();
    public static Map<String, JsonTemperature> dimensionTemperature = new HashMap<String, JsonTemperature>();
    public static Map<String, JsonTemperature> fluidTemperatures = new HashMap<String, JsonTemperature>();
    public static Map<String, List<JsonTemperatureIdentity>> heldItemTemperatures = new HashMap<String, List<JsonTemperatureIdentity>>();

    public static void registerArmorTemperature(ItemStack stack, float temperature) {
        String registryName = stack.func_77973_b().getRegistryName().toString();
        int metadata = -1;
        if (stack.func_77981_g()) {
            metadata = stack.func_77960_j();
        }
        JsonConfig.registerArmorTemperature(stack.func_77973_b().getRegistryName().toString(), temperature, new JsonItemIdentity(metadata));
    }

    public static void registerArmorTemperature(String registryName, float temperature) {
        JsonConfig.registerArmorTemperature(registryName, temperature, new JsonItemIdentity(-1));
    }

    public static void registerArmorTemperature(String registryName, float temperature, JsonItemIdentity identity) {
        if (!armorTemperatures.containsKey(registryName)) {
            armorTemperatures.put(registryName, new ArrayList());
        }
        List<JsonTemperatureIdentity> currentList = armorTemperatures.get(registryName);
        JsonTemperatureIdentity result = new JsonTemperatureIdentity(temperature, identity);
        for (int i = 0; i < currentList.size(); ++i) {
            JsonTemperatureIdentity jtm = currentList.get(i);
            if (!jtm.matches(identity)) continue;
            currentList.set(i, result);
            return;
        }
        currentList.add(result);
    }

    public static boolean registerBlockTemperature(Block block, float temperature, JsonPropertyValue ... properties) {
        return JsonConfig.registerBlockTemperature(block.getRegistryName().toString(), temperature, properties);
    }

    public static boolean registerBlockTemperature(String registryName, float temperature, JsonPropertyValue ... properties) {
        JsonPropertyTemperature jpt;
        int i;
        if (!blockTemperatures.containsKey(registryName)) {
            blockTemperatures.put(registryName, new ArrayList());
        }
        List<JsonPropertyTemperature> currentList = blockTemperatures.get(registryName);
        JsonPropertyTemperature result = new JsonPropertyTemperature(temperature, properties);
        if (properties.length > 0) {
            for (int i2 = 0; i2 < currentList.size(); ++i2) {
                JsonPropertyTemperature jpt2 = currentList.get(i2);
                if (!jpt2.matchesDescribedProperties(properties)) continue;
                currentList.set(i2, result);
                return true;
            }
            currentList.add(result);
            return true;
        }
        for (i = 0; i < currentList.size(); ++i) {
            jpt = currentList.get(i);
            if (jpt.properties.keySet().size() <= 0) continue;
            return false;
        }
        for (i = 0; i < currentList.size(); ++i) {
            jpt = currentList.get(i);
            if (jpt.properties.keySet().size() != 0) continue;
            currentList.set(i, result);
            return true;
        }
        currentList.add(result);
        return true;
    }

    public static void registerFluidTemperature(String fluidName, float temperature) {
        fluidTemperatures.put(fluidName, new JsonTemperature(temperature));
    }

    public static void registerConsumableTemperature(String group, ItemStack stack, float temperature, int duration) {
        String registryName = stack.func_77973_b().getRegistryName().toString();
        int metadata = -1;
        if (stack.func_77981_g()) {
            metadata = stack.func_77960_j();
        }
        JsonConfig.registerConsumableTemperature(group, registryName, temperature, duration, new JsonItemIdentity(metadata));
    }

    public static void registerConsumableTemperature(String group, String registryName, float temperature, int duration, JsonItemIdentity identity) {
        if (!consumableTemperature.containsKey(registryName)) {
            consumableTemperature.put(registryName, new ArrayList());
        }
        List<JsonConsumableTemperature> currentList = consumableTemperature.get(registryName);
        JsonConsumableTemperature result = new JsonConsumableTemperature(group, temperature, duration, identity);
        for (int i = 0; i < currentList.size(); ++i) {
            JsonConsumableTemperature jct = currentList.get(i);
            if (!jct.matches(identity)) continue;
            currentList.set(i, result);
            return;
        }
        currentList.add(result);
    }

    public static void registerConsumableThirst(ItemStack stack, int amount, float saturation, float thirstyChance) {
        String registryName = stack.func_77973_b().getRegistryName().toString();
        int metadata = -1;
        if (stack.func_77981_g()) {
            metadata = stack.func_77960_j();
        }
        JsonConfig.registerConsumableThirst(stack.func_77973_b().getRegistryName().toString(), amount, saturation, thirstyChance, new JsonItemIdentity(metadata));
    }

    public static void registerConsumableThirst(String registryName, int amount, float saturation, float thirstyChance, JsonItemIdentity identity) {
        if (!consumableThirst.containsKey(registryName)) {
            consumableThirst.put(registryName, new ArrayList());
        }
        List<JsonConsumableThirst> currentList = consumableThirst.get(registryName);
        JsonConsumableThirst result = new JsonConsumableThirst(amount, saturation, thirstyChance, identity);
        for (int i = 0; i < currentList.size(); ++i) {
            JsonConsumableThirst jct = currentList.get(i);
            if (!jct.matches(identity)) continue;
            currentList.set(i, result);
            return;
        }
        currentList.add(result);
    }

    public static void registerHeldItem(ItemStack stack, float temperature) {
        String registryName = stack.func_77973_b().getRegistryName().toString();
        int metadata = -1;
        if (stack.func_77981_g()) {
            metadata = stack.func_77960_j();
        }
        JsonConfig.registerHeldItem(stack.func_77973_b().getRegistryName().toString(), temperature, new JsonItemIdentity(metadata));
    }

    public static void registerHeldItem(String registryName, float temperature, JsonItemIdentity identity) {
        if (!heldItemTemperatures.containsKey(registryName)) {
            heldItemTemperatures.put(registryName, new ArrayList());
        }
        List<JsonTemperatureIdentity> currentList = heldItemTemperatures.get(registryName);
        JsonTemperatureIdentity result = new JsonTemperatureIdentity(temperature, identity);
        for (int i = 0; i < currentList.size(); ++i) {
            JsonTemperatureIdentity jtm = currentList.get(i);
            if (!jtm.matches(identity)) continue;
            currentList.set(i, result);
            return;
        }
        currentList.add(result);
    }

    public static void registerDimensionTemperature(int dimension, float temperature) {
        JsonConfig.registerDimensionTemperature("" + dimension, temperature);
    }

    public static void registerDimensionTemperature(String dimensionNumber, float temperature) {
        dimensionTemperature.put(dimensionNumber, new JsonTemperature(temperature));
    }
}

