/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.world;

import com.dhanantry.scapeandrunparasites.SRPMain;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.Level;

public class SRPSaveData
extends WorldSavedData {
    private static final String DATA_NAME = "srparasites_global_data";
    private static SRPSaveData instance;
    private ArrayList<Integer> dimNumberID = new ArrayList();
    private ArrayList<Integer> dimNumberPoint = new ArrayList();
    private ArrayList<Integer> lockedParasites = new ArrayList();

    public SRPSaveData() {
        super(DATA_NAME);
    }

    public SRPSaveData(String name) {
        super(name);
    }

    public static SRPSaveData get(World world) {
        MapStorage storage = world.func_175693_T();
        instance = (SRPSaveData)storage.func_75742_a(SRPSaveData.class, DATA_NAME);
        if (instance == null) {
            instance = new SRPSaveData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            String[] here = new String[3];
            int id = 0;
            for (int i = 0; i < SRPConfigSystems.evolutionParasiteLock.length; ++i) {
                if (SRPConfigSystems.evolutionParasiteLock[i] == null) continue;
                here = SRPConfigSystems.evolutionParasiteLock[i].split(";");
                id = Integer.parseInt(here[2]);
                SRPSaveData.instance.lockedParasites.add(id);
            }
        }
        return instance;
    }

    public void func_76184_a(NBTTagCompound compound) {
        NBTTagList tagListX;
        if (compound.func_74764_b("srplockedparasites")) {
            tagListX = compound.func_150295_c("srplockedparasites", 10);
            for (int i = 0; i < tagListX.func_74745_c(); ++i) {
                NBTTagCompound tagX = tagListX.func_150305_b(i);
                int id = tagX.func_74762_e("parasiteid" + i);
                this.lockedParasites.add(i, id);
            }
        }
        if (compound.func_74764_b("dimnumberid")) {
            tagListX = compound.func_150295_c("dimnumberid", 10);
            NBTTagList tagListY = compound.func_150295_c("dimnumberpoint", 10);
            if (tagListX.func_74745_c() != tagListY.func_74745_c()) {
                SRPMain.logger.log(Level.ERROR, "Problem while reading dims");
            } else {
                for (int i = 0; i < tagListX.func_74745_c(); ++i) {
                    NBTTagCompound tagX = tagListX.func_150305_b(i);
                    int coordx = tagX.func_74762_e("dimid" + i);
                    this.dimNumberID.add(i, coordx);
                    NBTTagCompound tagY = tagListY.func_150305_b(i);
                    int coordy = tagY.func_74762_e("dimpt" + i);
                    this.dimNumberPoint.add(i, coordy);
                }
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList tagListXX = new NBTTagList();
        for (int i = 0; i < this.lockedParasites.size(); ++i) {
            int id = this.lockedParasites.get(i);
            NBTTagCompound tagX = new NBTTagCompound();
            tagX.func_74768_a("parasiteid" + i, id);
            tagListXX.func_74742_a((NBTBase)tagX);
        }
        compound.func_74782_a("srplockedparasites", (NBTBase)tagListXX);
        if (this.dimNumberID.size() != this.dimNumberPoint.size()) {
            SRPMain.logger.log(Level.ERROR, "Problem while writing dims");
        } else {
            NBTTagList tagListX = new NBTTagList();
            NBTTagList tagListY = new NBTTagList();
            for (int i = 0; i < this.dimNumberID.size(); ++i) {
                int coordx = this.dimNumberID.get(i);
                int coordy = this.dimNumberPoint.get(i);
                NBTTagCompound tagX = new NBTTagCompound();
                tagX.func_74768_a("dimid" + i, coordx);
                tagListX.func_74742_a((NBTBase)tagX);
                NBTTagCompound tagY = new NBTTagCompound();
                tagY.func_74768_a("dimpt" + i, coordy);
                tagListY.func_74742_a((NBTBase)tagY);
            }
            compound.func_74782_a("dimnumberid", (NBTBase)tagListX);
            compound.func_74782_a("dimnumberpoint", (NBTBase)tagListY);
        }
        return compound;
    }

    public boolean checkParasiteID(int in) {
        for (int i = 0; i < this.lockedParasites.size(); ++i) {
            if (this.lockedParasites.get(i) != in) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Integer> getLockedList() {
        return this.lockedParasites;
    }

    public void unlockParasite(int in) {
        for (int i = 0; i < this.lockedParasites.size(); ++i) {
            if (this.lockedParasites.get(i) != in) continue;
            this.lockedParasites.remove(i);
            this.func_76185_a();
            return;
        }
    }

    public void clearNodeList() {
        this.dimNumberID = new ArrayList();
        this.dimNumberPoint = new ArrayList();
        this.func_76185_a();
    }

    public void resetLock() {
        ArrayList<Integer> aaa = new ArrayList<Integer>();
        String[] here = new String[3];
        int id = 0;
        for (int i = 0; i < SRPConfigSystems.evolutionParasiteLock.length; ++i) {
            if (SRPConfigSystems.evolutionParasiteLock[i] == null) continue;
            here = SRPConfigSystems.evolutionParasiteLock[i].split(";");
            id = Integer.parseInt(here[2]);
            aaa.add(id);
        }
        this.lockedParasites = aaa;
        this.func_76185_a();
    }

    public void saveDimPoints(int phase) {
        for (int i = 0; i < this.dimNumberID.size(); ++i) {
            if (this.dimNumberID.get(i) != phase) continue;
            int points = this.dimNumberPoint.get(i) + 1;
            this.dimNumberPoint.set(i, points);
            this.func_76185_a();
            return;
        }
        this.dimNumberPoint.add(1);
        this.dimNumberID.add(phase);
        this.func_76185_a();
    }

    public void removeDimPoints(int id) {
        for (int i = 0; i < this.dimNumberID.size(); ++i) {
            if (this.dimNumberID.get(i) != id) continue;
            this.dimNumberPoint.remove(i);
            this.dimNumberID.remove(i);
            this.func_76185_a();
            return;
        }
    }

    public int getDimPoints(int id, boolean in) {
        for (int i = 0; i < this.dimNumberID.size(); ++i) {
            if (this.dimNumberID.get(i) != id) continue;
            int r = this.dimNumberPoint.get(i);
            if (in) {
                this.dimNumberPoint.remove(i);
                this.dimNumberID.remove(i);
            }
            this.func_76185_a();
            return r;
        }
        return 0;
    }
}

