/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.collect.ImmutableList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class PlayerHelper {
    public static void giveItem(EntityPlayer player, ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        if (!player.field_71071_by.func_70441_a(copy)) {
            EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, copy);
            entityItem.func_174868_q();
            entityItem.func_145797_a(player.func_70005_c_());
            player.field_70170_p.func_72838_d((Entity)entityItem);
        }
    }

    public static void removeItem(EntityPlayer player, ItemStack stack) {
        ImmutableList inventories = ImmutableList.of((Object)player.field_71071_by.field_70462_a, (Object)player.field_71071_by.field_184439_c, (Object)player.field_71071_by.field_70460_b);
        for (NonNullList inv : inventories) {
            for (int i = 0; i < inv.size(); ++i) {
                if (stack != inv.get(i)) continue;
                inv.set(i, (Object)ItemStack.field_190927_a);
                return;
            }
        }
    }

    public static NBTTagCompound getPersistedDataSubcompound(EntityPlayer player, String subcompoundKey) {
        NBTTagCompound persistedData;
        NBTTagCompound forgeData = player.getEntityData();
        if (!forgeData.func_74764_b("PlayerPersisted")) {
            forgeData.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        if (!(persistedData = forgeData.func_74775_l("PlayerPersisted")).func_74764_b(subcompoundKey)) {
            persistedData.func_74782_a(subcompoundKey, (NBTBase)new NBTTagCompound());
        }
        return persistedData.func_74775_l(subcompoundKey);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(EntityPlayer player) {
        return PlayerHelper.getNonEmptyStacks(player, true, true, true, s -> true);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(EntityPlayer player, Predicate<ItemStack> predicate) {
        return PlayerHelper.getNonEmptyStacks(player, true, true, true, predicate);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(EntityPlayer player, boolean includeMain, boolean includeOffHand, boolean includeArmor) {
        return PlayerHelper.getNonEmptyStacks(player, includeMain, includeOffHand, includeArmor, s -> true);
    }

    @Nonnull
    public static NonNullList<ItemStack> getNonEmptyStacks(EntityPlayer player, boolean includeMain, boolean includeOffHand, boolean includeArmor, Predicate<ItemStack> predicate) {
        NonNullList list = NonNullList.func_191196_a();
        if (includeMain) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        if (includeOffHand) {
            for (ItemStack stack : player.field_71071_by.field_184439_c) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        if (includeArmor) {
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                list.add((Object)stack);
            }
        }
        return list;
    }

    @Nonnull
    public static ItemStack getFirstValidStack(EntityPlayer player, boolean includeMain, boolean includeOffHand, boolean includeArmor, Predicate<ItemStack> predicate) {
        if (includeOffHand) {
            for (ItemStack stack : player.field_71071_by.field_184439_c) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        if (includeArmor) {
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        if (includeMain) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack.func_190926_b() || !predicate.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }
}

