/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.guidebook.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.gui.TexturedButton;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.guidebook.IGuideEntry;
import net.silentchaos512.lib.guidebook.button.EntryButton;
import net.silentchaos512.lib.guidebook.gui.GuiEntry;
import net.silentchaos512.lib.guidebook.gui.GuiGuide;
import net.silentchaos512.lib.guidebook.internal.GuiGuideBase;

@SideOnly(value=Side.CLIENT)
public class GuiMainPage
extends GuiGuide {
    @Nullable
    private TexturedButton achievementButton;
    @Nullable
    private TexturedButton configButton;
    private GuiButton tutorialButton;
    private boolean showTutorial;
    private String bookletName;
    private String bookletEdition;
    private List<String> quote;
    private String quoteGuy;

    public GuiMainPage(GuideBook book, GuiScreen previousScreen) {
        super(book, previousScreen, null);
    }

    private List<IGuideEntry> getDisplayedEntries() {
        ArrayList<IGuideEntry> displayed = new ArrayList<IGuideEntry>();
        for (IGuideEntry entry : this.book.getEntries()) {
            if (!entry.visibleOnFrontPage()) continue;
            displayed.add(entry);
        }
        return displayed;
    }

    @Override
    public void func_73866_w_() {
        String playerName;
        super.func_73866_w_();
        this.bookletName = "guide." + this.book.getModId() + ".manualName.1";
        String usedQuote = this.book.selectQuote(this.field_146297_k.field_71441_e.field_73012_v);
        if (!usedQuote.isEmpty()) {
            String[] quoteSplit = usedQuote.split("@");
            if (quoteSplit.length > 0) {
                this.quote = this.field_146289_q.func_78271_c(quoteSplit[0], 120);
            }
            this.quoteGuy = quoteSplit.length > 1 ? quoteSplit[1] : null;
        }
        this.bookletEdition = (playerName = this.field_146297_k.field_71439_g.func_70005_c_()).equalsIgnoreCase("derp") ? "derp edition" : this.book.getEditionString((EntityPlayer)this.field_146297_k.field_71439_g);
        int xPos = this.guiLeft - 4;
        ArrayList<String> configText = new ArrayList<String>();
        configText.add(TextFormatting.GOLD + this.book.i18n.translate("guide", "configButton.name", new Object[0]));
        if (this.book.getConfigScreen(this) != null) {
            this.configButton = new TexturedButton(this.book.getResourceGadgets(), -388, xPos += 20, this.guiTop + this.ySize - 30, 188, 14, 16, 16, configText);
            this.field_146292_n.add(this.configButton);
        }
        ArrayList<String> achievementText = new ArrayList<String>();
        achievementText.add(TextFormatting.GOLD + this.book.i18n.translate("guide", "achievementButton.name", new Object[0]));
        if (this.book.getAchievementScreen(this) != null) {
            this.achievementButton = new TexturedButton(this.book.getResourceGadgets(), -389, xPos += 20, this.guiTop + this.ySize - 30, 204, 14, 16, 16, achievementText);
            this.field_146292_n.add(this.achievementButton);
        }
        for (int i = 0; i < 12; ++i) {
            List<IGuideEntry> displayed = this.getDisplayedEntries();
            if (displayed.size() <= i) {
                return;
            }
            IGuideEntry entry = displayed.get(i);
            this.field_146292_n.add(new EntryButton(this, i, this.guiLeft + 156, this.guiTop + 11 + i * 13, 115, 10, "- " + entry.getLocalizedNameWithFormatting(), ItemStack.field_190927_a));
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof EntryButton) {
            IGuideEntry entry;
            List<IGuideEntry> displayed = this.getDisplayedEntries();
            if (displayed.size() > button.field_146127_k && (entry = displayed.get(button.field_146127_k)) != null) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiEntry(this.book, this.previousScreen, (GuiGuideBase)this, entry, 0, "", false));
            }
        } else if (button == this.achievementButton) {
            GuiScreen achievements = this.book.getAchievementScreen(this);
            if (achievements != null) {
                this.field_146297_k.func_147108_a(achievements);
            }
        } else if (button == this.configButton) {
            GuiScreen config = this.book.getConfigScreen(this);
            if (config != null) {
                this.field_146297_k.func_147108_a(config);
            }
        } else if (this.showTutorial && button == this.tutorialButton) {
            if (this.hasBookmarkButtons()) {
                if (!GuiMainPage.func_146272_n()) {
                    // empty if block
                }
                this.showTutorial = false;
                this.tutorialButton.field_146125_m = false;
                this.configButton.field_146125_m = true;
                this.achievementButton.field_146125_m = true;
            }
        } else {
            super.func_146284_a(button);
        }
    }

    @Override
    public void drawScreenPre(int mouseX, int mouseY, float partialTicks) {
        super.drawScreenPre(mouseX, mouseY, partialTicks);
        String strg = TextFormatting.DARK_GREEN + this.book.i18n.translate(this.bookletName, new Object[0]);
        this.field_146289_q.func_78276_b(strg, this.guiLeft + 72 - this.field_146289_q.func_78256_a(strg) / 2 - 3, this.guiTop + 19, 0);
        strg = TextFormatting.DARK_GREEN + this.book.i18n.translate("guide", "manualName.2", new Object[0]);
        this.field_146289_q.func_78276_b(strg, this.guiLeft + 72 - this.field_146289_q.func_78256_a(strg) / 2 - 3, this.guiTop + 19 + this.field_146289_q.field_78288_b, 0);
        strg = TextFormatting.GOLD + TextFormatting.ITALIC.toString() + this.bookletEdition;
        this.field_146289_q.func_78276_b(strg, this.guiLeft + 72 - this.field_146289_q.func_78256_a(strg) / 2 - 3, this.guiTop + 40, 0);
        if (this.showTutorial) {
            String text = TextFormatting.BLUE + "It looks like this is the first time you are using this manual. \nIf you click the button below, some useful bookmarks will be stored at the bottom of the GUI. You should definitely check them out to get started with " + this.book.getModId() + "! \nIf you don't want this, shift-click the button.";
            this.renderSplitScaledAsciiString(text, this.guiLeft + 11, this.guiTop + 55, 0, false, this.getMediumFontSize(), 120);
        } else if (this.quote != null && !this.quote.isEmpty()) {
            int quoteSize = this.quote.size();
            for (int i = 0; i < quoteSize; ++i) {
                this.renderScaledAsciiString(TextFormatting.ITALIC + this.quote.get(i), this.guiLeft + 25, this.guiTop + 90 + i * 8, 0, false, this.getMediumFontSize());
            }
            if (this.quoteGuy != null) {
                this.renderScaledAsciiString("- " + this.quoteGuy, this.guiLeft + 60, this.guiTop + 93 + quoteSize * 8, 0, false, this.getLargeFontSize());
            }
        }
    }

    @Override
    public void addOrModifyItemRenderer(ItemStack renderedStack, int x, int y, float scale, boolean shouldTryTransfer) {
    }
}

