/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.event;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.util.PlayerHelper;

@Mod.EventBusSubscriber(modid="silentlib")
@ParametersAreNonnullByDefault
public final class InitialSpawnItems {
    private static final Map<ResourceLocation, Supplier<ItemStack>> SPAWN_ITEMS = new HashMap<ResourceLocation, Supplier<ItemStack>>();
    private static final String NBT_KEY = "silentlib.SpawnItemsGiven";

    private InitialSpawnItems() {
    }

    public static void add(ResourceLocation key, Supplier<ItemStack> stack) {
        SPAWN_ITEMS.put(key, stack);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        NBTTagCompound givenItems = PlayerHelper.getPersistedDataSubcompound(player, NBT_KEY);
        SPAWN_ITEMS.forEach((key, supplier) -> {
            ItemStack stack;
            String nbtKey = key.toString().replaceFirst(":", ".");
            if (!givenItems.func_74767_n(nbtKey) && !(stack = (ItemStack)supplier.get()).func_190926_b()) {
                SilentLib.LOGGER.debug("Giving player {} spawn item \"{}\" = {}", (Object)player.func_70005_c_(), (Object)nbtKey, (Object)stack);
                PlayerHelper.giveItem(player, stack);
                givenItems.func_74757_a(nbtKey, true);
            }
        });
    }
}

