/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.item.crafting;

import com.google.common.collect.Lists;
import dev.satyrn.wolfarmor.item.ItemWolfArmor;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeWolfArmorDyes
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        ItemStack armorItemStack = ItemStack.field_190927_a;
        ArrayList dyes = Lists.newArrayList();
        for (int slotIndex = 0; slotIndex < inv.func_70302_i_(); ++slotIndex) {
            ItemStack stackInSlot = inv.func_70301_a(slotIndex);
            if (stackInSlot.func_190926_b()) continue;
            if (stackInSlot.func_77973_b() instanceof ItemWolfArmor) {
                ItemWolfArmor armorItem = (ItemWolfArmor)stackInSlot.func_77973_b();
                if (!armorItem.getMaterial().getCanBeDyed() || !armorItemStack.func_190926_b()) {
                    return false;
                }
                armorItemStack = stackInSlot;
                continue;
            }
            if (!DyeUtils.isDye((ItemStack)stackInSlot)) {
                return false;
            }
            dyes.add(stackInSlot);
        }
        return !armorItemStack.func_190926_b() && !dyes.isEmpty();
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack result = ItemStack.field_190927_a;
        int[] rgbColor = new int[3];
        int colorMultiplier = 0;
        int colorCount = 0;
        ItemWolfArmor armorItem = null;
        for (int slotIndex = 0; slotIndex < inv.func_70302_i_(); ++slotIndex) {
            ItemStack stackInSlot = inv.func_70301_a(slotIndex);
            if (stackInSlot.func_190926_b()) continue;
            if (stackInSlot.func_77973_b() instanceof ItemWolfArmor) {
                armorItem = (ItemWolfArmor)stackInSlot.func_77973_b();
                if (!armorItem.getMaterial().getCanBeDyed() || !result.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                result = stackInSlot.func_77946_l();
                result.func_190920_e(1);
                if (!armorItem.getHasColor(result)) continue;
                int armorColor = armorItem.getColor(result);
                float rArmor = (float)(armorColor >> 16 & 0xFF) / 255.0f;
                float gArmor = (float)(armorColor >> 8 & 0xFF) / 255.0f;
                float bArmor = (float)(armorColor & 0xFF) / 255.0f;
                colorMultiplier = (int)((float)colorMultiplier + Math.max(rArmor, Math.max(gArmor, bArmor)) * 255.0f);
                rgbColor[0] = (int)((float)rgbColor[0] + rArmor * 255.0f);
                rgbColor[1] = (int)((float)rgbColor[1] + gArmor * 255.0f);
                rgbColor[2] = (int)((float)rgbColor[2] + bArmor * 255.0f);
                ++colorCount;
                continue;
            }
            if (!DyeUtils.isDye((ItemStack)stackInSlot) || !DyeUtils.colorFromStack((ItemStack)stackInSlot).isPresent()) {
                return ItemStack.field_190927_a;
            }
            float[] dyeColorMultipliers = ((EnumDyeColor)DyeUtils.colorFromStack((ItemStack)stackInSlot).get()).func_193349_f();
            int rDye = (int)(dyeColorMultipliers[0] * 255.0f);
            int gDye = (int)(dyeColorMultipliers[1] * 255.0f);
            int bDye = (int)(dyeColorMultipliers[2] * 255.0f);
            colorMultiplier += Math.max(rDye, Math.max(gDye, bDye));
            rgbColor[0] = rgbColor[0] + rDye;
            rgbColor[1] = rgbColor[1] + gDye;
            rgbColor[2] = rgbColor[2] + bDye;
            ++colorCount;
        }
        if (armorItem == null) {
            return ItemStack.field_190927_a;
        }
        int rAvg = rgbColor[0] / colorCount;
        int gAvg = rgbColor[1] / colorCount;
        int bAvg = rgbColor[2] / colorCount;
        float colorMultiplierAvg = (float)colorMultiplier / (float)colorCount;
        float maxColorValue = Math.max(rAvg, Math.max(gAvg, bAvg));
        rAvg = (int)((float)rAvg * colorMultiplierAvg / maxColorValue);
        gAvg = (int)((float)gAvg * colorMultiplierAvg / maxColorValue);
        bAvg = (int)((float)bAvg * colorMultiplierAvg / maxColorValue);
        int finalColor = ((rAvg << 8) + gAvg << 8) + bAvg;
        armorItem.setColor(result, finalColor);
        return result;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }
}

