/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.item;

import dev.satyrn.wolfarmor.api.item.IWolfArmorMaterial;
import dev.satyrn.wolfarmor.api.item.WolfArmorMaterials;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;

@Immutable
public class WolfArmorMaterial
implements IWolfArmorMaterial {
    private final String name;
    private final int durability;
    private final double damageReductionAmount;
    private final int enchantability;
    private final boolean canBeDyed;
    private final int defaultColor;
    private final SoundEvent equipSound;
    private final boolean hasOverlay;
    private final Item repairItem;
    private final float toughness;

    WolfArmorMaterial(@Nonnull String name, @Nonnegative int durability, @Nonnegative double damageReductionAmount, @Nonnegative int enchantability, @Nonnull SoundEvent equipSound, @Nullable Item repairItem, @Nonnegative float toughness) {
        this(name, durability, damageReductionAmount, enchantability, false, 0xFFFFFF, equipSound, false, repairItem, toughness);
    }

    WolfArmorMaterial(@Nonnull String name, @Nonnegative int durability, @Nonnegative double damageReductionAmount, @Nonnegative int enchantability, boolean canBeDyed, int defaultColor, @Nonnull SoundEvent equipSound, boolean hasOverlay, @Nullable Item repairItem, @Nonnegative float toughness) {
        this.name = name;
        this.durability = durability;
        this.damageReductionAmount = damageReductionAmount;
        this.enchantability = enchantability;
        this.canBeDyed = canBeDyed;
        this.defaultColor = defaultColor;
        this.equipSound = equipSound;
        this.hasOverlay = hasOverlay;
        this.repairItem = repairItem;
        this.toughness = toughness;
    }

    public static void initializeMaterials() {
        WolfArmorMaterials.CLOTH = new WolfArmorMaterial("leather", 80, 6.0, 15, true, 10511680, SoundEvents.field_187728_s, true, Items.field_151116_aA, 0.0f);
        WolfArmorMaterials.CHAINMAIL = new WolfArmorMaterial("chainmail", 180, 12.0, 12, SoundEvents.field_187713_n, Items.field_191525_da, 0.0f);
        WolfArmorMaterials.IRON = new WolfArmorMaterial("iron", 240, 15.0, 9, SoundEvents.field_187725_r, Items.field_151042_j, 0.0f);
        WolfArmorMaterials.GOLD = new WolfArmorMaterial("gold", 112, 12.0, 25, SoundEvents.field_187722_q, Items.field_151043_k, 0.0f);
        WolfArmorMaterials.DIAMOND = new WolfArmorMaterial("diamond", 528, 20.0, 10, SoundEvents.field_187716_o, Items.field_151045_i, 2.0f);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnegative
    public int getDurability() {
        return this.durability;
    }

    @Override
    @Nonnegative
    public double getDamageReductionAmount() {
        return this.damageReductionAmount;
    }

    @Override
    @Nonnegative
    public int getEnchantability() {
        return this.enchantability;
    }

    @Override
    public boolean getCanBeDyed() {
        return this.canBeDyed;
    }

    @Override
    public int getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    @Nonnull
    public SoundEvent getEquipSound() {
        return this.equipSound;
    }

    @Override
    public boolean getHasOverlay() {
        return this.hasOverlay;
    }

    @Override
    @Nullable
    public Item getRepairItem() {
        return this.repairItem;
    }

    @Override
    @Nonnegative
    public float getToughness() {
        return this.toughness;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WolfArmorMaterial implementation = (WolfArmorMaterial)o;
        return this.durability == implementation.durability && Double.compare(implementation.damageReductionAmount, this.damageReductionAmount) == 0 && this.enchantability == implementation.enchantability && this.canBeDyed == implementation.canBeDyed && this.defaultColor == implementation.defaultColor && this.hasOverlay == implementation.hasOverlay && Float.compare(implementation.toughness, this.toughness) == 0 && this.name.equals(implementation.name) && this.equipSound.equals(implementation.equipSound) && (this.repairItem != null ? this.repairItem.equals(implementation.repairItem) : implementation.repairItem == null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.durability;
        long temp = Double.doubleToLongBits(this.damageReductionAmount);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.enchantability;
        result = 31 * result + (this.canBeDyed ? 1 : 0);
        result = 31 * result + this.defaultColor;
        result = 31 * result + this.equipSound.hashCode();
        result = 31 * result + (this.hasOverlay ? 1 : 0);
        result = 31 * result + (this.repairItem != null ? this.repairItem.hashCode() : 0);
        result = 31 * result + (this.toughness != 0.0f ? Float.floatToIntBits(this.toughness) : 0);
        return result;
    }
}

