/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.config;

import com.google.common.collect.Maps;
import dev.satyrn.wolfarmor.WolfArmorMod;
import dev.satyrn.wolfarmor.api.config.settings.BooleanSetting;
import dev.satyrn.wolfarmor.api.config.settings.Setting;
import dev.satyrn.wolfarmor.common.network.packets.ConfigSyncMessage;
import dev.satyrn.wolfarmor.config.settings.WolfFoodStatsSetting;
import dev.satyrn.wolfarmor.config.settings.WolfInventorySizeSetting;
import dev.satyrn.wolfarmor.util.WolfFoodStatsLevel;
import dev.satyrn.wolfarmor.util.WolfInventorySize;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WolfArmorConfig {
    private final Setting<Boolean> chestEnabled = ((Setting)((Setting)((Setting)new BooleanSetting(true).setCategory("general")).setName("backpack")).setComment("Enables or disables wolf backpacks.")).setRequiresWorldReload().setSynchronizes(true);
    private final Setting<WolfInventorySize> chestSize = ((Setting)((Setting)((Setting)((Setting)new WolfInventorySizeSetting(new WolfInventorySize(3, 2)).setCategory("general")).setName("backpack_size")).setComment("Sets the horizontal and vertical size of wolves' backpacks.")).setSynchronizes(true)).setRequiresWorldReload().setConfigWidgetClassName("dev.satyrn.wolfarmor.client.gui.config.WolfInventorySizeWidget");
    private final Setting<Boolean> enableRecipes = ((Setting)((Setting)((Setting)new BooleanSetting(true).setCategory("general")).setName("allow_crafting")).setComment("Allows or disallows players to craft the wolf armor items.")).setRequiresMinecraftRestart();
    public BehaviorCategory behavior;
    @SideOnly(value=Side.CLIENT)
    public ClientCategory client;
    private Configuration configuration;
    private final Map<String, Setting<?>> settings = Maps.newLinkedHashMap();
    @SideOnly(value=Side.CLIENT)
    private boolean connected;

    private void addSettingsFromClass(Object object) {
        for (Field field : object.getClass().getDeclaredFields()) {
            Setting setting;
            if (!Setting.class.isAssignableFrom(field.getType())) continue;
            try {
                setting = (Setting)field.get(object);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            this.settings.put(setting.getFullName(), setting);
        }
    }

    public Collection<Setting<?>> getSettings() {
        return this.settings.values();
    }

    public Setting<?> getSetting(String fullName) {
        return this.settings.get(fullName);
    }

    public void load() {
        if (this.settings.size() == 0) {
            return;
        }
        this.configuration.load();
        this.getSettings().forEach(setting -> setting.loadFromConfiguration(this.configuration));
    }

    public void save() {
        this.getSettings().forEach(setting -> setting.saveToConfiguration(this.configuration));
        this.configuration.save();
    }

    public boolean getChestEnabled() {
        return this.chestEnabled.getCurrentValue();
    }

    public boolean getHowlAtMoonEnabled() {
        return this.behavior.howlAtMoonEnabled.getCurrentValue();
    }

    public boolean getAutoHealEnabled() {
        return this.behavior.autoHealEnabled.getCurrentValue();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getArmorRendered() {
        return this.client.armorRendered.getCurrentValue();
    }

    public boolean getChestRendered() {
        return this.client.chestRendered.getCurrentValue();
    }

    public WolfInventorySize getChestSize() {
        return this.chestSize.getCurrentValue();
    }

    public WolfFoodStatsLevel getFoodStatsLevel() {
        return this.behavior.useFoodStats.getCurrentValue();
    }

    public boolean getCanStarve() {
        return this.behavior.wolvesCanStarve.getCurrentValue();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getStatsRendered() {
        return this.client.wolfStatsRendered.getCurrentValue();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getStatsInGui() {
        return this.client.statsInGui.getCurrentValue();
    }

    public boolean getEnableCrafting() {
        return this.enableRecipes.getCurrentValue();
    }

    public void initialize(String configDirectory) {
        File configFile;
        File directory = new File(configDirectory);
        if (!directory.exists()) {
            WolfArmorMod.getLogger().debug(String.format("Creating new configuration directory '%s'", configDirectory));
            if (!directory.mkdirs()) {
                WolfArmorMod.getLogger().error("Unable to create new configuration directory!");
                throw new RuntimeException("Failed to create configuration directory");
            }
        }
        if (!(configFile = new File(directory.getPath() + "/" + "wolfarmor" + ".cfg")).exists()) {
            WolfArmorMod.getLogger().debug("Config file not found; a new configuration file will be initialized.");
        }
        this.configuration = new Configuration(configFile);
        this.addSettingsFromClass(this);
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.getType().getName().endsWith("Category")) continue;
            try {
                field.set(this, field.getType().getConstructors()[0].newInstance(new Object[0]));
                this.addSettingsFromClass(field.get(this));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.load();
        if (this.configuration.hasChanged()) {
            this.save();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sync(@Nonnull NBTTagCompound data) {
        if (this.connected) {
            for (String key : data.func_150296_c()) {
                NBTBase tag = data.func_74781_a(key);
                Setting<?> setting = this.getSetting(key);
                if (setting == null || !setting.getSynchronizes()) continue;
                setting.readSynchronized(tag);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.connected = true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (!this.connected) {
            return;
        }
        this.getSettings().forEach(Setting::onDisconnect);
        this.connected = false;
    }

    @SubscribeEvent
    public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent event) {
        if (!event.getModID().equals("wolfarmor")) {
            return;
        }
        if (event.isWorldRunning()) {
            WolfArmorMod.getNetworkChannel().sendToAllWhere(ConfigSyncMessage.create(), WolfArmorConfig::isNotServerOwner);
        }
        this.save();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (WolfArmorConfig.isNotServerOwner(event.player) || !(event.player instanceof EntityPlayerMP)) {
            return;
        }
        WolfArmorMod.getNetworkChannel().sendTo(ConfigSyncMessage.create(), (EntityPlayerMP)event.player);
    }

    private static boolean isNotServerOwner(EntityPlayer player) {
        return player.func_70005_c_().equalsIgnoreCase(FMLCommonHandler.instance().getMinecraftServerInstance().func_71214_G());
    }

    @SideOnly(value=Side.CLIENT)
    public static final class ClientCategory {
        private static final String CATEGORY = "client";
        final Setting<Boolean> armorRendered = ((Setting)((Setting)new BooleanSetting(true).setCategory("client")).setName("armor_model")).setComment("Enables or disables wolf armor model rendering. Disable this if you have an unsupported  custom model mod, or if rendering the armor causes other issues.");
        final Setting<Boolean> chestRendered = ((Setting)((Setting)new BooleanSetting(true).setCategory("client")).setName("backpack_model")).setComment("Enables or disables wolf backpack model rendering. Disable if you have an unsupported custom model mod, or if rendering the backpack causes other issues.");
        final Setting<Boolean> statsInGui = ((Setting)((Setting)new BooleanSetting(true).setCategory("client")).setName("stats_in_gui")).setComment("Enables or disables displaying the wolf health, armor, and food stats in the inventory");
        final Setting<Boolean> wolfStatsRendered = ((Setting)((Setting)new BooleanSetting(false).setCategory("client")).setName("stats_in_nameplate")).setComment("Enables or disables displaying health, armor, and food stats above tamed wolves' heads.");
    }

    public static final class BehaviorCategory {
        private static final String CATEGORY = "behavior";
        final Setting<Boolean> howlAtMoonEnabled = ((Setting)((Setting)((Setting)new BooleanSetting(false).setCategory("behavior")).setName("howl_at_moon")).setComment("Enables or disables untamed wolves howling at the moon")).setSynchronizes(true);
        final Setting<Boolean> autoHealEnabled = ((Setting)((Setting)((Setting)new BooleanSetting(true).setCategory("behavior")).setName("auto_eat")).setComment("Enables or disables wolves automatically eating food when their health is low.")).setSynchronizes(true);
        final Setting<WolfFoodStatsLevel> useFoodStats = ((Setting)((Setting)((Setting)new WolfFoodStatsSetting().setCategory("behavior")).setName("hunger")).setComment("Sets whether or not to enable hunger for wolves. Valid values are disabled, heal, and full. \"Heal\" will override the default heal functionality and heal wolves w/ saturation. \"Full\" will cause unfed wolves to lose health until 4 hearts are left, or, if starvation is enabled, until it dies.")).setRequiresWorldReload().setSynchronizes(true);
        final Setting<Boolean> wolvesCanStarve = ((Setting)((Setting)((Setting)new BooleanSetting(false).setCategory("behavior")).setName("starvation")).setComment("Sets whether or not wolves can starve to death if hunger is set to \"full\".")).setRequiresWorldReload().setSynchronizes(true);
    }
}

