/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.GameTime;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public abstract class ConsumableItem
extends ForgeItem {
    private final int maxUseDuration;

    public ConsumableItem(ForgeMod mod, UnitConfig config, CreativeTabs tab, CommonTime.Interval consumeDuration) {
        super(mod, config, tab);
        consumeDuration = ForgeConfig.getTimeInSeconds(config, this.getUnitCategory(), "consumeDuration", consumeDuration, "Defines time required for item to be consumed.");
        this.maxUseDuration = (int)GameTime.inServerTicks(consumeDuration);
    }

    public abstract EnumAction func_77661_b(ItemStack var1);

    public int func_77626_a(ItemStack stack) {
        return this.maxUseDuration;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase living) {
        EntityPlayer player;
        EntityPlayer entityPlayer = player = living instanceof EntityPlayer ? (EntityPlayer)living : null;
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
        }
        return super.func_77654_b(stack, world, living);
    }
}

