/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.qualitytools.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tmtravlr.qualitytools.config.ConfigLoader;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.oredict.OreDictionary;

public class CustomMaterial {
    public Item item;
    public int meta;
    public NBTTagCompound tag;
    public String oreDict;

    public boolean itemMatches(ItemStack material) {
        if (material == null || material.func_190926_b()) {
            return false;
        }
        if (this.item != null) {
            if (this.item == material.func_77973_b() && (this.meta == Short.MAX_VALUE || this.meta == material.func_77952_i()) && NBTUtil.func_181123_a((NBTBase)this.tag, (NBTBase)material.func_77978_p(), (boolean)true)) {
                return true;
            }
        } else if (this.oreDict != null) {
            int[] entries = OreDictionary.getOreIDs((ItemStack)material);
            int oreId = OreDictionary.getOreID((String)this.oreDict);
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i] != oreId) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.item == null ? 0 : Item.field_150901_e.func_148757_b((Object)this.item));
        result = 31 * result + this.meta;
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        result = 31 * result + (this.oreDict == null ? 0 : this.oreDict.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomMaterial other = (CustomMaterial)obj;
        if (this.item != other.item) {
            return false;
        }
        if (this.meta != other.meta) {
            return false;
        }
        if (this.tag == null ? other.tag != null : !this.tag.equals((Object)other.tag)) {
            return false;
        }
        return !(this.oreDict == null ? other.oreDict != null : !this.oreDict.equals(other.oreDict));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        if (this.item != null) {
            compound.func_74778_a("Item", "" + Item.field_150901_e.func_177774_c((Object)this.item));
        }
        if (this.meta != Short.MAX_VALUE) {
            compound.func_74768_a("Meta", this.meta);
        }
        if (this.tag != null) {
            compound.func_74782_a("Tag", (NBTBase)this.tag);
        }
        if (this.oreDict != null) {
            compound.func_74778_a("OreDict", this.oreDict);
        }
        return compound;
    }

    public CustomMaterial readFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("Item")) {
            this.item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(compound.func_74779_i("Item")));
        }
        this.meta = compound.func_74764_b("Meta") ? compound.func_74762_e("Meta") : Short.MAX_VALUE;
        if (compound.func_74764_b("Tag")) {
            this.tag = compound.func_74775_l("Tag");
        }
        if (compound.func_74764_b("OreDict")) {
            this.oreDict = compound.func_74779_i("OreDict");
        }
        return this;
    }

    public static class Serializer
    implements JsonDeserializer<CustomMaterial> {
        public CustomMaterial deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            String tagString;
            JsonObject json = jsonElement.getAsJsonObject();
            CustomMaterial reforgeMaterial = new CustomMaterial();
            reforgeMaterial.meta = JsonUtils.func_151208_a((JsonObject)json, (String)"meta", (int)Short.MAX_VALUE);
            String string = tagString = json.has("tag") ? JsonUtils.func_151200_h((JsonObject)json, (String)"tag") : "";
            if (!tagString.isEmpty() && !tagString.equals("{}")) {
                try {
                    reforgeMaterial.tag = JsonToNBT.func_180713_a((String)tagString);
                }
                catch (NBTException e) {
                    FMLLog.warning((String)"[Quality Tools] Problem loading item tag %s in reforging materials.json. Ignoring.", (Object[])new Object[]{tagString});
                    ConfigLoader.problems.add("reforging materials.json: Problem loading nbt tag: " + e.getMessage() + ", with tag " + tagString);
                }
            }
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"ore_dict")) {
                reforgeMaterial.oreDict = JsonUtils.func_151200_h((JsonObject)json, (String)"ore_dict");
            }
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"item")) {
                String itemName = JsonUtils.func_151200_h((JsonObject)json, (String)"item");
                reforgeMaterial.item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName));
                if (reforgeMaterial.item == null) {
                    if (ConfigLoader.ignoreUnknownItems) {
                        FMLLog.warning((String)"[Quality Tools] Unknown item %s in reforging materials.json. Ignoring.", (Object[])new Object[]{itemName});
                        return null;
                    }
                    throw new JsonParseException("Unknown item " + itemName);
                }
            }
            return reforgeMaterial;
        }
    }
}

