/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.asset;

import goblinbob.mobends.core.asset.AssetLocation;
import goblinbob.mobends.core.asset.AssetsModule;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AssetModels {
    public static final AssetModels INSTANCE = new AssetModels();
    private static final Logger LOGGER = LogManager.getLogger();
    private final FaceBakery faceBakery = new FaceBakery();
    private final Map<AssetLocation, SimpleBakedModel> bakedModelMap = new HashMap<AssetLocation, SimpleBakedModel>();

    public SimpleBakedModel register(AssetLocation location) throws IOException {
        FileInputStream stream = new FileInputStream(AssetsModule.INSTANCE.getAssetFile(location));
        ModelBlock model = ModelBlock.func_178307_a((Reader)new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8)));
        SimpleBakedModel bakedModel = this.bakeModel(model, (ITransformation)ModelRotation.X0_Y0, false);
        this.bakedModelMap.put(location, bakedModel);
        return bakedModel;
    }

    public void clearCache() {
        this.bakedModelMap.clear();
    }

    public SimpleBakedModel getModel(AssetLocation location) {
        if (!this.bakedModelMap.containsKey((Object)location)) {
            try {
                SimpleBakedModel bakedModel = this.register(location);
                this.bakedModelMap.put(location, bakedModel);
                return bakedModel;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to bake asset model: {}", (Object)location.toString(), (Object)e);
                this.bakedModelMap.put(location, null);
                return null;
            }
        }
        return this.bakedModelMap.get((Object)location);
    }

    private AssetLocation resolveTextureName(String name) {
        if (name.equals("missingno")) {
            return null;
        }
        return new AssetLocation("textures/" + name);
    }

    protected BakedQuad makeBakedQuad(BlockPart p_177589_1_, BlockPartFace p_177589_2_, TextureAtlasSprite p_177589_3_, EnumFacing p_177589_4_, ITransformation p_177589_5_, boolean p_177589_6_) {
        return this.faceBakery.makeBakedQuad(p_177589_1_.field_178241_a, p_177589_1_.field_178239_b, p_177589_2_, p_177589_3_, p_177589_4_, p_177589_5_, p_177589_1_.field_178237_d, p_177589_6_, p_177589_1_.field_178238_e);
    }

    private SimpleBakedModel bakeModel(ModelBlock modelBlock, ITransformation modelRotationIn, boolean uvLocked) throws IOException {
        SimpleBakedModel.Builder modelBuilder = new SimpleBakedModel.Builder(modelBlock, modelBlock.func_187967_g());
        boolean particleTextureSet = false;
        if (modelBlock.func_178298_a().isEmpty()) {
            return null;
        }
        for (BlockPart blockpart : modelBlock.func_178298_a()) {
            for (EnumFacing enumfacing : blockpart.field_178240_c.keySet()) {
                BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get(enumfacing);
                AssetLocation textureLocation = this.resolveTextureName(modelBlock.func_178308_c(blockpartface.field_178242_d));
                if (textureLocation == null) continue;
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_174942_a((ResourceLocation)textureLocation);
                PngSizeInfo sizeInfo = new PngSizeInfo((InputStream)new FileInputStream(AssetsModule.INSTANCE.getAssetFile(textureLocation)));
                sprite.func_188538_a(sizeInfo, true);
                sprite.func_110971_a(sizeInfo.field_188533_a, sizeInfo.field_188534_b, 0, 0, false);
                if (!particleTextureSet) {
                    modelBuilder.func_177646_a(sprite);
                    particleTextureSet = true;
                }
                if (blockpartface.field_178244_b == null || !TRSRTransformation.isInteger((Matrix4f)modelRotationIn.getMatrix())) {
                    modelBuilder.func_177648_a(this.makeBakedQuad(blockpart, blockpartface, sprite, enumfacing, modelRotationIn, uvLocked));
                    continue;
                }
                modelBuilder.func_177650_a(modelRotationIn.rotate(blockpartface.field_178244_b), this.makeBakedQuad(blockpart, blockpartface, sprite, enumfacing, modelRotationIn, uvLocked));
            }
        }
        return (SimpleBakedModel)modelBuilder.func_177645_b();
    }
}

