/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.motion;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adhooks.motion.EntityTarget;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SinglePlayerTarget
extends EntityTarget<EntityPlayerSP> {
    protected Vect3d durableMotion = Vect3d.ZERO;
    protected int duration;
    protected boolean swinging;

    public SinglePlayerTarget(EntityPlayerSP target, double damping) {
        super(target, damping);
    }

    @Override
    public boolean exists() {
        return super.exists() || ((EntityPlayerSP)this.target).func_70089_S() && this.durableMotion.notZero();
    }

    public void setDurableMotion(Vect3d motion, int duration) {
        this.durableMotion = motion;
        this.duration = duration;
    }

    public void setSwinging(boolean value) {
        this.swinging = value;
    }

    protected Vect3d getSwingMotion() {
        Vect3d motion = ForgeEntity.getMotion((Entity)this.target);
        Vect3d movement = Vect3d.from((double)((EntityPlayerSP)this.target).field_70702_br, (double)0.0, (double)((EntityPlayerSP)this.target).field_191988_bg).rotateAroundY(-((EntityPlayerSP)this.target).field_70177_z);
        if (Vect3d.scalarMult((Vect3d)movement, (Vect3d)motion) < 0.0) {
            return Vect3d.ZERO;
        }
        return movement.projectOn(motion).scale(0.1);
    }

    @Override
    public void applyMotions() {
        if (this.swinging) {
            this.addDampedMotion(this.getSwingMotion());
        }
        this.swinging = false;
        if (this.duration > 0) {
            --this.duration;
            this.addDampedMotion(this.durableMotion);
        } else {
            this.durableMotion = Vect3d.ZERO;
        }
        super.applyMotions();
    }
}

