/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DebuffTimedSound
implements ITickableSound {
    private static final float volumeMultiplier = 1.25f;
    private final float minusPerTick;
    private final int debuffDuration;
    private final ResourceLocation soundLocation;
    private final SoundEvent event;
    private final WeakReference<EntityPlayerSP> player;
    private Sound sound;
    private float volume = 1.25f;
    private int ticks;
    private static final Map<SoundEvent, DebuffTimedSound> activeSounds = new HashMap<SoundEvent, DebuffTimedSound>();

    public static void playHurtSound(SoundEvent event, int duration) {
        if (!FirstAidConfig.enableSoundSystem) {
            return;
        }
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        DebuffTimedSound matchingSound = activeSounds.get(event);
        if (matchingSound != null) {
            if (!matchingSound.func_147667_k()) {
                soundHandler.func_147683_b((ISound)matchingSound);
            }
            activeSounds.remove(event);
        }
        DebuffTimedSound newSound = new DebuffTimedSound(event, duration);
        soundHandler.func_147682_a((ISound)newSound);
        activeSounds.put(event, newSound);
    }

    public DebuffTimedSound(SoundEvent event, int debuffDuration) {
        this.event = event;
        this.soundLocation = event.func_187503_a();
        this.player = new WeakReference<EntityPlayerSP>(Minecraft.func_71410_x().field_71439_g);
        this.debuffDuration = Integer.min(300, debuffDuration);
        this.minusPerTick = 1.0f / (float)this.debuffDuration * 1.25f;
    }

    public boolean func_147667_k() {
        boolean done;
        EntityPlayerSP player = (EntityPlayerSP)this.player.get();
        boolean bl = done = player == null || this.ticks >= this.debuffDuration || player.func_110143_aJ() <= 0.0f;
        if (done) {
            activeSounds.remove(this.event);
        }
        return done;
    }

    @Nonnull
    public ResourceLocation func_147650_b() {
        return this.soundLocation;
    }

    @Nullable
    public SoundEventAccessor func_184366_a(@Nonnull SoundHandler handler) {
        SoundEventAccessor soundEventAccessor = handler.func_184398_a(this.soundLocation);
        if (soundEventAccessor == null) {
            FirstAid.LOGGER.warn("Missing sound for location " + this.soundLocation);
            this.sound = SoundHandler.field_147700_a;
        } else {
            this.sound = soundEventAccessor.func_148720_g();
        }
        return soundEventAccessor;
    }

    @Nonnull
    public Sound func_184364_b() {
        return this.sound;
    }

    @Nonnull
    public SoundCategory func_184365_d() {
        return SoundCategory.PLAYERS;
    }

    public boolean func_147657_c() {
        return false;
    }

    public int func_147652_d() {
        return 0;
    }

    public float func_147653_e() {
        return this.volume;
    }

    public float func_147655_f() {
        return 1.0f;
    }

    public float func_147649_g() {
        EntityPlayerSP player = (EntityPlayerSP)this.player.get();
        if (player == null) {
            return 0.0f;
        }
        return (float)player.field_70165_t;
    }

    public float func_147654_h() {
        EntityPlayerSP player = (EntityPlayerSP)this.player.get();
        if (player == null) {
            return 0.0f;
        }
        return (float)player.field_70163_u;
    }

    public float func_147651_i() {
        EntityPlayerSP player = (EntityPlayerSP)this.player.get();
        if (player == null) {
            return 0.0f;
        }
        return (float)player.field_70161_v;
    }

    @Nonnull
    public ISound.AttenuationType func_147656_j() {
        return ISound.AttenuationType.NONE;
    }

    public void func_73660_a() {
        ++this.ticks;
        this.volume = Math.max(0.15f, this.volume - this.minusPerTick);
    }
}

