/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.items.meta;

import com.teammetallurgy.aquaculture.items.meta.SubItem;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class MetaItem
extends Item {
    ArrayList<SubItem> subItems;

    public MetaItem() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public int addSubItem(SubItem subItem) {
        if (this.subItems == null) {
            this.subItems = new ArrayList();
        }
        this.subItems.add(subItem);
        return this.subItems.size() - 1;
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.subItems.size() - 1));
        String uname = this.subItems.get(i).getUnlocalizedName(stack);
        uname = uname.replace(" ", "_");
        return "item." + uname;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (SubItem subItem : this.subItems) {
                items.add((Object)subItem.getItemStack());
            }
        }
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, EntityLivingBase entityLiving) {
        int damage = stack.func_77952_i();
        if (entityLiving instanceof EntityPlayer && damage >= 0 && damage < this.subItems.size()) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            return this.subItems.get(damage).onEaten(stack, world, player);
        }
        return stack;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        int damage = stack.func_77952_i();
        if (damage >= 0 && damage < this.subItems.size()) {
            return this.subItems.get(damage).getMaxItemUseDuration(stack);
        }
        return 0;
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        int damage = stack.func_77952_i();
        if (damage >= 0 && damage < this.subItems.size()) {
            return this.subItems.get(damage).getItemUseAction(stack);
        }
        return EnumAction.NONE;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        int damage = itemStack.func_77952_i();
        if (damage >= 0 && damage < this.subItems.size()) {
            ItemStack result = this.subItems.get(damage).onItemRightClick(itemStack, world, player);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)result);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }
}

