/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.json;

import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.world.biome.Biome;

public interface IJsonBiomeApplier {
    public static final String DEFAULT = "...";
    public static final String REPLACE = "replace";
    public static final String BEFORE = "before";
    public static final String AFTER = "after";

    public void apply(BiomeDataBase var1, JsonElement var2, Biome var3);

    default public BiomeDataBase.Operation readMethod(JsonObject object) {
        JsonElement method = object.get("method");
        if (method != null && method.isJsonPrimitive() && method.getAsJsonPrimitive().isString()) {
            String methodName = method.getAsJsonPrimitive().getAsString();
            if (REPLACE.equals(methodName)) {
                return BiomeDataBase.Operation.REPLACE;
            }
            if (BEFORE.equals(methodName)) {
                return BiomeDataBase.Operation.SPLICE_BEFORE;
            }
            if (AFTER.equals(methodName)) {
                return BiomeDataBase.Operation.SPLICE_AFTER;
            }
        }
        return BiomeDataBase.Operation.REPLACE;
    }

    default public boolean isDefault(String candidate) {
        return DEFAULT.equals(candidate);
    }
}

