/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.featuregen;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.IPreGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenMound
implements IPreGenFeature,
IPostGenFeature {
    private static final SimpleVoxmap moundMap = new SimpleVoxmap(5, 4, 5, new byte[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 0, 0, 1, 1, 1, 0, 1, 2, 2, 2, 1, 1, 2, 2, 2, 1, 1, 2, 2, 2, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 3, 2));
    private final int moundCutoffRadius;

    public FeatureGenMound(int moundCutoffRadius) {
        this.moundCutoffRadius = moundCutoffRadius;
    }

    @Override
    public BlockPos preGeneration(World world, BlockPos rootPos, Species species, int radius, EnumFacing facing, SafeChunkBounds safeBounds, JoCode joCode) {
        if (radius >= this.moundCutoffRadius && safeBounds != SafeChunkBounds.ANY) {
            IBlockState initialDirtState = world.func_180495_p(rootPos);
            IBlockState initialUnderState = world.func_180495_p(rootPos.func_177977_b());
            if (initialUnderState.func_185904_a() == Material.field_151579_a || initialUnderState.func_185904_a() != Material.field_151578_c && initialUnderState.func_185904_a() != Material.field_151576_e) {
                Biome biome = world.func_180494_b(rootPos);
                initialUnderState = biome.field_76753_B;
            }
            rootPos = rootPos.func_177984_a();
            for (SimpleVoxmap.Cell cell : moundMap.getAllNonZeroCells()) {
                IBlockState placeState = cell.getValue() == 1 ? initialDirtState : initialUnderState;
                world.func_175656_a(rootPos.func_177971_a((Vec3i)cell.getPos()), placeState);
            }
        }
        return rootPos;
    }

    @Override
    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        if (radius < this.moundCutoffRadius && safeBounds != SafeChunkBounds.ANY) {
            BlockPos treePos = rootPos.func_177984_a();
            IBlockState belowState = world.func_180495_p(rootPos.func_177977_b());
            IBlockState branchState = world.func_180495_p(treePos);
            if (TreeHelper.getTreePart(branchState).getRadius(branchState) > 8) {
                for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                    BlockPos dPos = rootPos.func_177971_a(dir.getOffset());
                    world.func_175656_a(dPos, initialDirtState);
                    world.func_175656_a(dPos.func_177977_b(), belowState);
                }
                return true;
            }
        }
        return false;
    }
}

