/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.ExtendedBlockStateWater;
import com.ferreusveritas.dynamictrees.blocks.MimicProperty;
import com.ferreusveritas.dynamictrees.blocks.properties.UnlistedPropertyBool;
import com.ferreusveritas.dynamictrees.blocks.properties.UnlistedPropertyFloat;
import com.ferreusveritas.dynamictrees.tileentity.TileEntitySpecies;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRootyWater
extends BlockRooty {
    protected final boolean isSmoothWaterInstalled;
    protected static final AxisAlignedBB WATER_ROOTS_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9);
    public static final UnlistedPropertyBool[] RENDER_SIDES = new UnlistedPropertyBool[]{new UnlistedPropertyBool("render_d"), new UnlistedPropertyBool("render_u"), new UnlistedPropertyBool("render_n"), new UnlistedPropertyBool("render_s"), new UnlistedPropertyBool("render_w"), new UnlistedPropertyBool("render_e")};
    public static final UnlistedPropertyFloat[] CORNER_HEIGHTS = new UnlistedPropertyFloat[]{new UnlistedPropertyFloat("level_nw"), new UnlistedPropertyFloat("level_sw"), new UnlistedPropertyFloat("level_se"), new UnlistedPropertyFloat("level_ne")};
    private static final Vec3d acceleration_modifier = new Vec3d(0.0, 0.0, 0.0);

    public BlockRootyWater(boolean isTileEntity) {
        this(isTileEntity, "rootywater");
    }

    public BlockRootyWater(boolean isTileEntity, String name) {
        super(name, Material.field_151586_h, isTileEntity);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(super.func_176223_P());
        this.isSmoothWaterInstalled = Loader.isModLoaded((String)"smoothwater");
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockStateWater(this, new IProperty[]{LIFE}, new IUnlistedProperty[]{MimicProperty.MIMIC, RENDER_SIDES[0], RENDER_SIDES[1], RENDER_SIDES[2], RENDER_SIDES[3], RENDER_SIDES[4], RENDER_SIDES[5], CORNER_HEIGHTS[0], CORNER_HEIGHTS[1], CORNER_HEIGHTS[2], CORNER_HEIGHTS[3]});
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess access, BlockPos pos) {
        int avgLvl = 0;
        int total = 0;
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            IBlockState st = access.func_180495_p(pos.func_177972_a(dir));
            if (!st.func_177228_b().containsKey((Object)BlockLiquid.field_176367_b)) continue;
            avgLvl += ((Integer)st.func_177229_b((IProperty)BlockLiquid.field_176367_b)).intValue();
            ++total;
        }
        int n = avgLvl = total == 0 ? 7 : avgLvl / total;
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extState = (IExtendedBlockState)state;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                extState = extState.withProperty((IUnlistedProperty)RENDER_SIDES[dir.ordinal()], (Object)this.func_176225_a(state, access, pos, dir));
            }
            float defaultHeight = 1.0f - BlockLiquid.func_149801_b((int)avgLvl);
            float c0 = this.getFluidHeight(access, pos, Material.field_151586_h);
            float c1 = this.getFluidHeight(access, pos.func_177968_d(), Material.field_151586_h);
            float c2 = this.getFluidHeight(access, pos.func_177974_f().func_177968_d(), Material.field_151586_h);
            float c3 = this.getFluidHeight(access, pos.func_177974_f(), Material.field_151586_h);
            if (this.isSmoothWaterInstalled) {
                if (c0 > 0.88f && c0 < 0.89f) {
                    c0 = 0.875f;
                }
                if (c1 > 0.88f && c1 < 0.89f) {
                    c1 = 0.875f;
                }
                if (c2 > 0.88f && c2 < 0.89f) {
                    c2 = 0.875f;
                }
                if (c3 > 0.88f && c3 < 0.89f) {
                    c3 = 0.875f;
                }
            }
            float avg = 0.0f;
            int i = 0;
            if (c0 > 0.0f) {
                avg += c0;
                ++i;
            }
            if (c1 > 0.0f) {
                avg += c1;
                ++i;
            }
            if (c2 > 0.0f) {
                avg += c2;
                ++i;
            }
            if (c3 > 0.0f) {
                avg += c3;
                ++i;
            }
            if (i > 0) {
                avg /= (float)i;
            }
            defaultHeight = avg;
            extState = extState.withProperty((IUnlistedProperty)CORNER_HEIGHTS[0], (Object)Float.valueOf(c0 < 0.0f ? defaultHeight : c0));
            extState = extState.withProperty((IUnlistedProperty)CORNER_HEIGHTS[1], (Object)Float.valueOf(c1 < 0.0f ? defaultHeight : c1));
            extState = extState.withProperty((IUnlistedProperty)CORNER_HEIGHTS[2], (Object)Float.valueOf(c2 < 0.0f ? defaultHeight : c2));
            extState = extState.withProperty((IUnlistedProperty)CORNER_HEIGHTS[3], (Object)Float.valueOf(c3 < 0.0f ? defaultHeight : c3));
            return extState;
        }
        return state;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState newState;
        int y = fromPos.func_177956_o() - pos.func_177956_o();
        if (y < 1 && this.canFlowInto(worldIn, fromPos, newState = worldIn.func_180495_p(fromPos))) {
            newState.func_177230_c().func_176226_b(worldIn, pos, newState, 0);
            worldIn.func_180501_a(fromPos, Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    private boolean canFlowInto(World worldIn, BlockPos pos, IBlockState state) {
        Material material = state.func_185904_a();
        return material != this.field_149764_J && material != Material.field_151587_i && !this.isBlocked(worldIn, pos, state);
    }

    private boolean isBlocked(World worldIn, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        Material mat = state.func_185904_a();
        if (!(block instanceof BlockDoor) && block != Blocks.field_150472_an && block != Blocks.field_150468_ap && block != Blocks.field_150436_aH) {
            return mat == Material.field_151567_E || mat == Material.field_189963_J || mat.func_76230_c();
        }
        return true;
    }

    private float getFluidHeight(IBlockAccess blockAccess, BlockPos blockPosIn, Material blockMaterial) {
        int i = 0;
        int w = 0;
        float f = 0.0f;
        for (int j = 0; j < 4; ++j) {
            BlockPos blockpos = blockPosIn.func_177982_a(-(j & 1), 0, -(j >> 1 & 1));
            if (blockAccess.func_180495_p(blockpos.func_177984_a()).func_185904_a() == blockMaterial) {
                return 1.0f;
            }
            IBlockState iblockstate = blockAccess.func_180495_p(blockpos);
            Material material = iblockstate.func_185904_a();
            if (material != blockMaterial) {
                if (!material.func_76220_a()) {
                    f += 1.0f;
                    ++i;
                }
            } else {
                int k = (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b);
                if (k >= 8 || k == 0) {
                    f += BlockLiquid.func_149801_b((int)k) * 10.0f;
                    i += 10;
                }
                f += BlockLiquid.func_149801_b((int)k);
                ++i;
            }
            if (!iblockstate.func_185917_h() && !iblockstate.func_185914_p() && !iblockstate.func_185913_b()) continue;
            ++w;
        }
        if (w == 0 && i == 0) {
            return 0.0f;
        }
        if (i == 0) {
            return -1.0f;
        }
        return 1.0f - f / (float)i;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IBlockState upState = world.func_180495_p(pos.func_177984_a());
        if (TreeHelper.isBranch(upState)) {
            return new ItemStack((Block)TreeHelper.getBranch(upState).getFamily().getDynamicBranch());
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IBlockState getMimic(IBlockAccess access, BlockPos pos) {
        return Blocks.field_150355_j.func_176223_P();
    }

    @Override
    public IBlockState getDecayBlockState(IBlockAccess access, BlockPos pos) {
        return Blocks.field_150355_j.func_176223_P();
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.CUTOUT_MIPPED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (blockAccess.func_180495_p(pos.func_177972_a(side)).func_185904_a() == Material.field_151586_h) {
            return false;
        }
        if (side == EnumFacing.UP) {
            return true;
        }
        return !blockAccess.func_180495_p(pos.func_177972_a(side)).doesSideBlockRendering(blockAccess, pos.func_177972_a(side), side.func_176734_d());
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos.func_177972_a(face)).func_185904_a() == Material.field_151586_h;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return this.field_149758_A ? new TileEntitySpecies() : null;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public Vec3d func_176197_a(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        return motion.func_178787_e(acceleration_modifier);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return WATER_ROOTS_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public int getRadiusForConnection(IBlockState state, IBlockAccess blockAccess, BlockPos pos, BlockBranch from, EnumFacing side, int fromRadius) {
        return 8;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        int i = source.func_175626_b(pos, 0);
        int j = source.func_175626_b(pos.func_177984_a(), 0);
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        return super.getFogColor(world, pos, Blocks.field_150355_j.func_176223_P(), entity, originalColor, partialTicks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        return true;
    }
}

