/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="dynamictrees")
public class ModRecipes {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void register(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        ModItems.dendroPotion.registerRecipes((IForgeRegistry<IRecipe>)registry);
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("dynamictrees", "dirtbucket"), null, (ItemStack)new ItemStack((Item)ModItems.dirtBucket), (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151133_ar), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150346_d))});
        for (BlockPlanks.EnumType woodType : BlockPlanks.EnumType.values()) {
            Species species = TreeRegistry.findSpecies(new ResourceLocation("dynamictrees", woodType.func_176610_l().replace("_", "")));
            ItemStack saplingStack = new ItemStack(Blocks.field_150345_g, 1, woodType.func_176839_a());
            ItemStack seedStack = species.getSeedStack(1);
            ModRecipes.createDirtBucketExchangeRecipes(saplingStack, seedStack, true);
        }
        if (ModConfigs.enableAppleTrees) {
            ModRecipes.createDirtBucketExchangeRecipes(new ItemStack(Items.field_151034_e), TreeRegistry.findSpecies(new ResourceLocation("dynamictrees", "apple")).getSeedStack(1), false);
        }
    }

    public static void createDirtBucketExchangeRecipes(ItemStack saplingStack, ItemStack seedStack, boolean seedIsSapling) {
        ModRecipes.createDirtBucketExchangeRecipes(saplingStack, seedStack, seedIsSapling, "seed");
    }

    public static void createDirtBucketExchangeRecipes(ItemStack saplingStack, ItemStack seedStack, boolean seedIsSapling, String suffix) {
        ResourceLocation name = seedStack.func_77973_b() instanceof Seed ? ((Seed)seedStack.func_77973_b()).getSpecies(seedStack).getRegistryName() : seedStack.func_77973_b().getRegistryName();
        ModRecipes.createDirtBucketExchangeRecipes(saplingStack, seedStack, seedIsSapling, suffix, name);
    }

    public static void createDirtBucketExchangeRecipes(ItemStack saplingStack, ItemStack seedStack, boolean seedIsSapling, String suffix, ResourceLocation species) {
        ModRecipes.createSaplingToSeedWithDirtBucketRecipe(saplingStack, seedStack, suffix, species);
        if (seedIsSapling) {
            ModRecipes.createSeedToSaplingWithDirtBucketRecipe(seedStack, saplingStack, "sapling", species);
        }
    }

    public static void createSeedToSaplingWithDirtBucketRecipe(ItemStack seedStack, ItemStack saplingStack, String suffix, ResourceLocation species) {
        if (ModConfigs.compatRecipeForSaplings && !saplingStack.func_190926_b() && !seedStack.func_190926_b()) {
            String speciesPath = species.func_110623_a();
            String speciesDomain = species.func_110624_b();
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(speciesDomain, speciesPath + suffix), null, (ItemStack)saplingStack, (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{seedStack}), Ingredient.func_193367_a((Item)ModItems.dirtBucket)});
            OreDictionary.registerOre((String)"treeSapling", (ItemStack)seedStack);
        }
    }

    public static void createSaplingToSeedWithDirtBucketRecipe(ItemStack saplingStack, ItemStack seedStack, String suffix, ResourceLocation species) {
        if (!saplingStack.func_190926_b() && !seedStack.func_190926_b()) {
            String speciesPath = species.func_110623_a();
            String speciesDomain = species.func_110624_b();
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(speciesDomain, speciesPath + suffix), null, (ItemStack)seedStack, (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{saplingStack}), Ingredient.func_193367_a((Item)ModItems.dirtBucket)});
        }
    }

    public static void createDirtBucketExchangeRecipesWithFruit(ItemStack saplingStack, ItemStack seedStack, ItemStack fruitStack, boolean seedIsSapling, boolean requiresBonemeal) {
        ModRecipes.createDirtBucketExchangeRecipesWithFruit(saplingStack, seedStack, fruitStack, seedIsSapling, "seed", requiresBonemeal);
    }

    public static void createDirtBucketExchangeRecipesWithFruit(ItemStack saplingStack, ItemStack seedStack, ItemStack fruitStack, boolean seedIsSapling, String suffix, boolean requiresBonemeal) {
        ResourceLocation name = seedStack.func_77973_b() instanceof Seed ? ((Seed)seedStack.func_77973_b()).getSpecies(seedStack).getRegistryName() : seedStack.func_77973_b().getRegistryName();
        ModRecipes.createDirtBucketExchangeRecipesWithFruit(saplingStack, seedStack, fruitStack, seedIsSapling, suffix, name, requiresBonemeal);
    }

    public static void createDirtBucketExchangeRecipesWithFruit(ItemStack saplingStack, ItemStack seedStack, ItemStack fruitStack, boolean seedIsSapling, String suffix, ResourceLocation species, boolean requiresBonemeal) {
        ModRecipes.createDirtBucketExchangeRecipes(saplingStack, seedStack, seedIsSapling, suffix, species);
        ModRecipes.createFruitToSeedRecipe(seedStack, fruitStack, species, requiresBonemeal);
    }

    private static void createFruitToSeedRecipe(ItemStack seedStack, ItemStack fruitStack, ResourceLocation species, boolean requiresBonemeal) {
        if (fruitStack != null && !fruitStack.func_190926_b()) {
            ResourceLocation seedFromFruit = new ResourceLocation(species.func_110624_b(), species.func_110623_a() + "seedfromfruit");
            Ingredient fruit = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{fruitStack});
            Ingredient bonemeal = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 15)});
            Ingredient dirtBucket = Ingredient.func_193367_a((Item)ModItems.dirtBucket);
            if (requiresBonemeal) {
                GameRegistry.addShapelessRecipe((ResourceLocation)seedFromFruit, null, (ItemStack)seedStack, (Ingredient[])new Ingredient[]{fruit, bonemeal, dirtBucket});
            } else {
                GameRegistry.addShapelessRecipe((ResourceLocation)seedFromFruit, null, (ItemStack)seedStack, (Ingredient[])new Ingredient[]{fruit, dirtBucket});
            }
        }
    }
}

