/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.multiblocksystem;

import com.teamacronymcoders.base.Base;
import com.teamacronymcoders.base.multiblocksystem.IMultiblockPart;
import com.teamacronymcoders.base.multiblocksystem.IMultiblockRegistry;
import com.teamacronymcoders.base.multiblocksystem.MultiblockControllerBase;
import com.teamacronymcoders.base.tileentities.TileEntityBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class MultiblockTileEntityBase<T extends MultiblockControllerBase>
extends TileEntityBase
implements IMultiblockPart {
    private MultiblockControllerBase controller = null;
    private boolean visited = false;
    private boolean saveMultiblockData = false;
    private NBTTagCompound cachedMultiblockData = null;
    private static final IMultiblockRegistry REGISTRY = Base.proxy.initMultiblockRegistry();

    @Override
    public Set<MultiblockControllerBase> attachToNeighbors() {
        IMultiblockPart[] partsToCheck;
        HashSet<MultiblockControllerBase> controllers = null;
        MultiblockControllerBase bestController = null;
        for (IMultiblockPart neighborPart : partsToCheck = this.getNeighboringParts()) {
            MultiblockControllerBase candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblockController()).getClass().equals(this.getMultiblockControllerType())) continue;
            if (controllers == null) {
                controllers = new HashSet<MultiblockControllerBase>();
                bestController = candidate;
            } else if (!controllers.contains(candidate) && candidate.shouldConsume(bestController)) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            this.controller = bestController;
            bestController.attachBlock(this);
        }
        return controllers;
    }

    @Override
    public void assertDetached() {
        if (this.controller != null) {
            BlockPos coord = this.getWorldPosition();
            Base.instance.getLogger().info(String.format("[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", coord.func_177958_n(), coord.func_177956_o(), coord.func_177952_p()));
            this.controller = null;
        }
    }

    @Override
    protected void readFromDisk(NBTTagCompound data) {
        if (data.func_74764_b("multiblockData")) {
            this.cachedMultiblockData = data.func_74775_l("multiblockData");
        }
    }

    @Override
    protected NBTTagCompound writeToDisk(NBTTagCompound data) {
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound multiblockData = new NBTTagCompound();
            ((MultiblockControllerBase)this.getMultiblockController()).writeToDisk(multiblockData);
            data.func_74782_a("multiblockData", (NBTBase)multiblockData);
        }
        return data;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.detachSelf(false);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.detachSelf(true);
    }

    public void func_145829_t() {
        super.func_145829_t();
        REGISTRY.onPartAdded(this.func_145831_w(), this);
    }

    @Override
    public boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Override
    public NBTTagCompound getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public abstract void onMachineAssembled(MultiblockControllerBase var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public boolean isConnected() {
        return this.controller != null;
    }

    public T getMultiblockController() {
        return (T)this.controller;
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public void setUnvisited() {
        this.visited = false;
    }

    @Override
    public void setVisited() {
        this.visited = true;
    }

    @Override
    public boolean isVisited() {
        return this.visited;
    }

    @Override
    public void onAssimilated(MultiblockControllerBase newController) {
        assert (this.controller != newController);
        this.controller = newController;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        this.controller = newController;
    }

    @Override
    public void onDetached(MultiblockControllerBase oldController) {
        this.controller = null;
    }

    @Override
    public abstract MultiblockControllerBase createNewMultiblock();

    @Override
    public IMultiblockPart[] getNeighboringParts() {
        ArrayList<IMultiblockPart> neighborParts = new ArrayList<IMultiblockPart>();
        BlockPos partPosition = this.getWorldPosition();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos neighborPosition = partPosition.func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(neighborPosition);
            if (!(te instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        return neighborParts.toArray(new IMultiblockPart[neighborParts.size()]);
    }

    @Override
    public void onOrphaned(MultiblockControllerBase controller, int oldSize, int newSize) {
        this.func_70296_d();
        this.func_145831_w().func_175646_b(this.getWorldPosition(), (TileEntity)this);
    }

    @Override
    public BlockPos getWorldPosition() {
        return this.field_174879_c;
    }

    @Override
    public boolean isPartInvalid() {
        return this.func_145837_r();
    }

    protected void notifyNeighborsOfBlockChange() {
        this.func_145831_w().func_175685_c(this.getWorldPosition(), this.func_145838_q(), true);
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(this, chunkUnloading);
            this.controller = null;
        }
        REGISTRY.onPartRemovedFromWorld(this.func_145831_w(), this);
    }

    protected void markMultiblockForRenderUpdate() {
        T controller = this.getMultiblockController();
        if (null != controller) {
            ((MultiblockControllerBase)controller).markMultiblockForRenderUpdate();
        }
    }
}

